/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.importer.model;

import com.atlassian.crowd.importer.model.MembershipDTO;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Result
implements Serializable {
    private Long usersImported = new Long(0L);
    private Long groupsImported = new Long(0L);
    private Long groupMembershipsImported = new Long(0L);
    private Set<String> usersFailedImport = new HashSet<String>();
    private Set<String> usersAlreadyExist = new HashSet<String>();
    private Set<String> groupsFailedImport = new HashSet<String>();
    private Set<String> groupsAlreadyExist = new HashSet<String>();
    private Set<String> groupMembershipsFailedImport = new HashSet<String>();
    private String message;

    public Long getUsersImported() {
        return this.usersImported;
    }

    public void setUsersImported(Long usersImported) {
        this.usersImported = usersImported;
    }

    public Long getGroupsImported() {
        return this.groupsImported;
    }

    public void setGroupsImported(Long groupsImported) {
        this.groupsImported = groupsImported;
    }

    public Long getGroupMembershipsImported() {
        return this.groupMembershipsImported;
    }

    public void setGroupMembershipsImported(Long groupMembershipsImported) {
        this.groupMembershipsImported = groupMembershipsImported;
    }

    public Set<String> getUsersFailedImport() {
        return this.usersFailedImport;
    }

    public void setUsersFailedImport(Set<String> usersFailedImport) {
        this.usersFailedImport = usersFailedImport;
    }

    public void addUsersFailedImport(String userName) {
        this.usersFailedImport.add(userName);
    }

    public void addExistingUser(String userName) {
        this.usersAlreadyExist.add(userName);
    }

    public void addExistingGroup(String groupName) {
        this.groupsAlreadyExist.add(groupName);
    }

    public Set<String> getGroupsFailedImport() {
        return this.groupsFailedImport;
    }

    public void setGroupsFailedImport(Set<String> groupsFailedImport) {
        this.groupsFailedImport = groupsFailedImport;
    }

    public void addGroupFailedImport(String groupName) {
        this.groupsFailedImport.add(groupName);
    }

    public Set<String> getGroupMembershipsFailedImport() {
        return this.groupMembershipsFailedImport;
    }

    public void setGroupMembershipsFailedImport(Set<String> groupMembershipsFailedImport) {
        this.groupMembershipsFailedImport = groupMembershipsFailedImport;
    }

    public void addGroupMembershipsImported(long memberships) {
        Result result = this;
        result.groupMembershipsImported = result.groupMembershipsImported + memberships;
    }

    public void addFailedGroupMembershipImport(MembershipDTO membership) {
        this.groupMembershipsFailedImport.add(membership.getRelationship());
    }

    public void addFailedUserMembershipImports(String groupName, Collection<String> usernames) {
        for (String username : usernames) {
            this.groupMembershipsFailedImport.add(MembershipDTO.getRelationshipKey(MembershipDTO.ChildType.USER, username, groupName));
        }
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Set<String> getUsersAlreadyExist() {
        return this.usersAlreadyExist;
    }

    public void setUsersAlreadyExist(Set<String> usersAlreadyExist) {
        this.usersAlreadyExist = usersAlreadyExist;
    }

    public Set<String> getGroupsAlreadyExist() {
        return this.groupsAlreadyExist;
    }

    public void setGroupsAlreadyExist(Set<String> groupsAlreadyExist) {
        this.groupsAlreadyExist = groupsAlreadyExist;
    }

    public void incrementGroupsImported() {
        this.groupsImported = this.groupsImported + 1L;
    }

    public void incrementUsersImported() {
        this.usersImported = this.usersImported + 1L;
    }

    public void incrementGroupMembershipsImported() {
        this.groupMembershipsImported = this.groupMembershipsImported + 1L;
    }
}

