/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.upgrade.tasks;

import com.atlassian.crowd.dao.application.ApplicationDAO;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.DirectoryMapping;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.upgrade.tasks.UpgradeTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpgradeTask452
implements UpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(UpgradeTask452.class);
    private final Collection<String> errors = new ArrayList<String>();
    private DirectoryDao directoryDao;
    private ApplicationDAO applicationDAO;

    @Override
    public String getBuildNumber() {
        return "452";
    }

    @Override
    public String getShortDescription() {
        return "Upgrading directories to contain UPDATE_USER_ATTRIBUTE, UPDATE_GROUP_ATTRIBUTE and UPDATE_ROLE_ATTRIBUTE permissions.";
    }

    @Override
    public void doUpgrade() throws Exception {
        String errorMessage;
        for (Directory directory : this.directoryDao.findAll()) {
            log.debug("Upgrading directory {}", (Object)directory);
            try {
                this.updateDirectory(directory);
            }
            catch (DataAccessException e) {
                errorMessage = "Could not update directory " + directory;
                log.error(errorMessage, (Throwable)e);
                this.errors.add(errorMessage + ", error is " + e.getMessage());
            }
        }
        for (Application application : this.findAllApplications()) {
            log.debug("Upgrading application {}", (Object)application);
            try {
                this.updateApplication(application);
            }
            catch (DataAccessException e) {
                errorMessage = "Could not update application " + application;
                log.error(errorMessage, (Throwable)e);
                this.errors.add(errorMessage + ", error is " + e.getMessage());
            }
        }
    }

    private void updateDirectory(Directory directory) throws DataAccessException, DirectoryNotFoundException {
        DirectoryImpl directoryToUpdate = new DirectoryImpl(directory);
        Set allowedOperations = directoryToUpdate.getAllowedOperations();
        if (allowedOperations.contains(OperationType.UPDATE_GROUP)) {
            directoryToUpdate.addAllowedOperation(OperationType.UPDATE_GROUP_ATTRIBUTE);
        }
        if (allowedOperations.contains(OperationType.UPDATE_USER)) {
            directoryToUpdate.addAllowedOperation(OperationType.UPDATE_USER_ATTRIBUTE);
        }
        if (allowedOperations.contains(OperationType.UPDATE_ROLE)) {
            directoryToUpdate.addAllowedOperation(OperationType.UPDATE_ROLE_ATTRIBUTE);
        }
        this.directoryDao.update((Directory)directoryToUpdate);
    }

    private void updateApplication(Application application) throws DataAccessException, ApplicationNotFoundException, DirectoryNotFoundException {
        for (DirectoryMapping directoryMapping : application.getDirectoryMappings()) {
            Set allowedOperations = directoryMapping.getAllowedOperations();
            if (allowedOperations.contains(OperationType.UPDATE_GROUP)) {
                directoryMapping.addAllowedOperation(OperationType.UPDATE_GROUP_ATTRIBUTE);
            }
            if (allowedOperations.contains(OperationType.UPDATE_USER)) {
                directoryMapping.addAllowedOperation(OperationType.UPDATE_USER_ATTRIBUTE);
            }
            if (allowedOperations.contains(OperationType.UPDATE_ROLE)) {
                directoryMapping.addAllowedOperation(OperationType.UPDATE_ROLE_ATTRIBUTE);
            }
            this.applicationDAO.updateDirectoryMapping(directoryMapping.getApplication().getId().longValue(), directoryMapping.getDirectory().getId().longValue(), directoryMapping.isAllowAllToAuthenticate(), directoryMapping.getAllowedOperations());
        }
    }

    private List<Application> findAllApplications() {
        return this.applicationDAO.search(QueryBuilder.queryFor(Application.class, (EntityDescriptor)EntityDescriptor.application()).returningAtMost(-1));
    }

    @Override
    public Collection<String> getErrors() {
        return this.errors;
    }

    public void setDirectoryDao(DirectoryDao directoryDao) {
        this.directoryDao = directoryDao;
    }

    public void setApplicationDao(ApplicationDAO applicationDao) {
        this.applicationDAO = applicationDao;
    }
}

