/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.importer.importers;

import com.atlassian.crowd.importer.config.Configuration;
import com.atlassian.crowd.importer.importers.JdbcImporter;
import com.atlassian.crowd.importer.mappers.jdbc.GroupMapper;
import com.atlassian.crowd.importer.mappers.jdbc.MembershipMapper;
import com.atlassian.crowd.importer.mappers.jdbc.UserMapper;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.util.PasswordHelper;
import org.springframework.jdbc.core.RowMapper;

class ConfluenceOSUserImporter
extends JdbcImporter {
    private static final String FIND_GROUPS_SQL = "SELECT groupname FROM os_group ORDER BY groupname";
    private static final String FIND_USERS_SQL = "SELECT username, passwd, (SELECT pe.string_val FROM OS_PROPERTYENTRY pe WHERE pe.entity_name='OSUser_user' AND pe.entity_id = osu.id AND pe.entity_key = 'email') AS email, (SELECT pe.string_val FROM OS_PROPERTYENTRY pe WHERE pe.entity_name='OSUser_user' AND pe.entity_id = osu.id AND pe.entity_key = 'fullName') AS fullname FROM os_user osu";
    private static final String FIND_USER_GROUP_MEMBERSHIPS = "SELECT (SELECT username FROM os_user osu WHERE osu.id=osug.user_id) AS username, (SELECT groupname FROM os_group osg WHERE osg.id=osug.group_id) AS groupname FROM os_user_group osug";

    public ConfluenceOSUserImporter(DirectoryManager directoryManager, PasswordHelper passwordHelper) {
        super(directoryManager, passwordHelper);
    }

    public String getSelectAllGroupsSQL() {
        return FIND_GROUPS_SQL;
    }

    public String getSelectAllUsersSQL() {
        return FIND_USERS_SQL;
    }

    public String getSelectAllUserGroupMembershipsSQL() {
        return FIND_USER_GROUP_MEMBERSHIPS;
    }

    public RowMapper getGroupMapper(Configuration configuration) {
        return new GroupMapper("groupname", "groupname", configuration.getDirectoryID());
    }

    public RowMapper getMembershipMapper() {
        return new MembershipMapper("username", "groupname");
    }

    public RowMapper getUserMapper(Configuration configuration, PasswordHelper passwordHelper) {
        return new UserMapper(configuration, passwordHelper, "username", "email", "fullname", "passwd");
    }
}

