package com.atlassian.crowd.manager.validation;

import java.net.InetAddress;

import com.atlassian.crowd.model.application.Application;

/**
 * Decides if a client address is authorised to connect as a given application.
 */
public interface ApplicationRemoteAddressValidator {
    /**
     * @param application   the Crowd application the client is trying to connect as
     * @param clientAddress the address of the client that is trying to connect
     * @return <code>true</code> if the connection is authorised
     */
    boolean validate(Application application, InetAddress clientAddress);
}
