package com.atlassian.crowd.manager.login;

public interface AsyncForgottenLoginManager {
    /**
     * Asynchronously sends a reset link to the first user with the matching <tt>username</tt> from all the active directories assigned
     * to the application.
     *
     * @param username           username of the user to send the password reset link
     * @param tokenExpirySeconds number of seconds before generated token expires, or DEFAULT_TOKEN_EXPIRY_SECONDS
     */
    void sendResetLink(String username, int tokenExpirySeconds);

    /**
     * <p>Asynchronously sends the usernames associated with the given email address. No email will be sent if there are no usernames
     * associated with a given <code>email</code>.</p>
     *
     * @param email email address of the user
     */
    void sendUsernames(String email);
}
