package com.atlassian.crowd.service.cluster;

import com.atlassian.annotations.ExperimentalApi;

import java.time.Duration;
import java.util.Optional;

/**
 * Represents additional monitoring information about the cluster node and it's environment
 */
@ExperimentalApi
public interface ClusterNodeDetails {
    /**
     * @return a string representation of the cluster node's host ip address
     */
    String getIpAddress();

    /**
     * @return the hostname of the cluster host
     */
    String getHostname();

    /**
     * @return the current allocated heap size of the node's JVM, in bytes
     */
    Long getCurrentHeapSize();

    /**
     * @return the max heap size of the node's JVM, in bytes
     */
    Long getMaxHeapSize();

    /**
     * @return an estimate of the average cpu load of the node, over the last minute, or none if not available
     */
    Optional<Double> getAverageLoad();

    /**
     * @return the uptime of the node
     */
    Duration getUptime();
}