package com.atlassian.crowd.model.licensing;

import com.google.common.base.MoreObjects;

import javax.annotation.Nullable;
import java.util.Objects;
import java.util.Optional;

public class ApplicationLicensedDirectory {

    private final String id;
    @Nullable
    private final String name;
    private final boolean isCrowdDirectory;
    @Nullable
    private final Long crowdDirectoryId;

// The code below has been generated by BoB the Builder of Beans based on the class' fields.
// Everything after this comment will be regenerated if you invoke BoB again.
// If you don't know who BoB is, you can find him here: https://bitbucket.org/atlassianlabs/bob-the-builder-of-beans

    protected ApplicationLicensedDirectory(String id, @Nullable String name, boolean isCrowdDirectory, @Nullable Long crowdDirectoryId) {
        this.id = Objects.requireNonNull(id);
        this.name = name;
        this.isCrowdDirectory = isCrowdDirectory;
        this.crowdDirectoryId = crowdDirectoryId;
    }

    public String getId() {
        return id;
    }

    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public boolean getIsCrowdDirectory() {
        return isCrowdDirectory;
    }

    public Optional<Long> getCrowdDirectoryId() {
        return Optional.ofNullable(crowdDirectoryId);
    }

    public static ApplicationLicensedDirectory.Builder builder() {
        return new ApplicationLicensedDirectory.Builder();
    }

    public static ApplicationLicensedDirectory.Builder builder(ApplicationLicensedDirectory data) {
        return new ApplicationLicensedDirectory.Builder(data);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        ApplicationLicensedDirectory that = (ApplicationLicensedDirectory) o;

        return Objects.equals(this.getId(), that.getId()) && Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getIsCrowdDirectory(), that.getIsCrowdDirectory()) && Objects.equals(this.getCrowdDirectoryId(), that.getCrowdDirectoryId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getId(), getName(), getIsCrowdDirectory(), getCrowdDirectoryId());
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("id", getId())
                .add("name", getName())
                .add("isCrowdDirectory", getIsCrowdDirectory())
                .add("crowdDirectoryId", getCrowdDirectoryId())
                .toString();
    }

    public static final class Builder {

        private String id;
        private String name;
        private boolean isCrowdDirectory;
        private Long crowdDirectoryId;

        private Builder() {
        }

        private Builder(ApplicationLicensedDirectory initialData) {
            this.id = initialData.getId();
            this.name = initialData.getName().orElse(null);
            this.isCrowdDirectory = initialData.getIsCrowdDirectory();
            this.crowdDirectoryId = initialData.getCrowdDirectoryId().orElse(null);
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setName(@Nullable String name) {
            this.name = name;
            return this;
        }

        public Builder setIsCrowdDirectory(boolean isCrowdDirectory) {
            this.isCrowdDirectory = isCrowdDirectory;
            return this;
        }

        public Builder setCrowdDirectoryId(@Nullable Long crowdDirectoryId) {
            this.crowdDirectoryId = crowdDirectoryId;
            return this;
        }

        public ApplicationLicensedDirectory build() {
            return new ApplicationLicensedDirectory(id, name, isCrowdDirectory, crowdDirectoryId);
        }
    }
}
