package com.atlassian.crowd.manager.sso;

import com.atlassian.annotations.Internal;
import com.atlassian.crowd.model.sso.KeyCertificatePair;

import java.util.Optional;

/**
 * A service for managing pairs of certificate and private key used in SSO.
 *
 * @since 3.4.0
 */
@Internal
public interface SamlSSOCertificateServiceInternal extends SamlSSOCertificateService {
    /**
     * @param keyCertificatePairId the id of the key-certificate pair to fetch
     * @return key-certificate pair based on passed keyCertificatePairId if found, none otherwise
     */
    Optional<KeyCertificatePair> getKeyCertificatePair(long keyCertificatePairId);
}