package com.atlassian.crowd.manager.permission;

import com.atlassian.crowd.exception.FeatureInaccessibleException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.model.group.Group;

/**
 * Checks, assigns and revokes access to administer groups by other groups and users
 * @since 3.3.0
 */
public interface GroupAdministrationConfigurationService {

    /**
     * Grants administration rights basing on the passed mapping
     * @param mapping the mapping
     */
    void grantGroupPermissions(GroupGroupAdministrationMapping mapping) throws GroupNotFoundException, FeatureInaccessibleException;

    /**
     * Grants administration rights basing on the passed mapping
     * @param mapping the mapping
     */
    void grantGroupPermissions(UserGroupAdministrationMapping mapping) throws UserNotFoundException,
                                                                              GroupNotFoundException, FeatureInaccessibleException;

    /**
     * Removes grant for the specified admin group and the target group
     * @param mapping data regarding the admin group and the target group
     */
    void revokeGroupPermissions(GroupGroupAdministrationMapping mapping) throws GroupNotFoundException, FeatureInaccessibleException;

    /**
     * Removes grant for the specified admin user and the target group
     * @param mapping data regarding the admin user and the target group
     */
    void revokeGroupPermissions(UserGroupAdministrationMapping mapping) throws UserNotFoundException, GroupNotFoundException,
                                                                               FeatureInaccessibleException;

    /**
     * Searches and returns all administrators a given group
     * @param group the group
     * @return the administrators
     */
    SingleGroupAdministrationMappings getGroupAdministrators(Group group) throws GroupNotFoundException, FeatureInaccessibleException;
}
