package com.atlassian.crowd.manager.rememberme;

import java.time.Duration;

/**
 * Represents basic Remember Me configuration in Crowd
 */
public interface CrowdSpecificRememberMeSettings {

    /**
     * Provides information whether Remember Me functionality is Enabled at the moment
     * @return {@code true} if Remember Me is enabled, {@code false} otherwise
     */
    boolean isEnabled();

    /**
     * Default state of Remember Me configuration
     */
    boolean DEFAULT_ENABLED = true;

    /**
     * @return {@link Duration} after which Remember Me token should expire
     */
    Duration getExpirationDuration();

    /**
     * Default expiration duration
     */
    Duration DEFAULT_EXPIRATION_DURATION = Duration.ofDays(30);
}
