/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.mail;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.crowd.util.mail.SMTPServer;

@ExperimentalApi
public class MailConfiguration {
    private final SMTPServer smtpServer;
    private final String serverAlertAddress;

    public MailConfiguration(Builder builder) {
        this.smtpServer = builder.smtpServer;
        this.serverAlertAddress = builder.serverAlertAddress;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(MailConfiguration mailServerModel) {
        return new Builder(mailServerModel);
    }

    public SMTPServer getSmtpServer() {
        return this.smtpServer;
    }

    public String getServerAlertAddress() {
        return this.serverAlertAddress;
    }

    public static final class Builder {
        private SMTPServer smtpServer;
        private String serverAlertAddress;

        private Builder() {
        }

        private Builder(MailConfiguration mailServerModel) {
            this.smtpServer = mailServerModel.getSmtpServer();
            this.serverAlertAddress = mailServerModel.getServerAlertAddress();
        }

        public Builder setSmtpServer(SMTPServer smtpServer) {
            this.smtpServer = smtpServer;
            return this;
        }

        public Builder setServerAlertAddress(String serverAlertAddress) {
            this.serverAlertAddress = serverAlertAddress;
            return this;
        }

        public MailConfiguration build() {
            return new MailConfiguration(this);
        }
    }
}

