package com.atlassian.crowd.manager.mail;

import javax.mail.internet.InternetAddress;
import java.text.MessageFormat;

public class MailSendException extends Exception {
    private static final String MAIL_SEND_EXCEPTION_MESSAGE = "Could not send email to ";

    public MailSendException(InternetAddress email) {
        super(MAIL_SEND_EXCEPTION_MESSAGE + email);
    }

    public MailSendException(InternetAddress email, Throwable cause) {
        super(MAIL_SEND_EXCEPTION_MESSAGE + email + ": " + cause.getMessage(), cause);
    }

    public MailSendException(Throwable cause) {
        super(cause);
    }
}
