package com.atlassian.crowd.manager.mail;

import javax.mail.internet.InternetAddress;

public interface MailManager {
    /**
     * Sends an HTML email using the configured mail server (remote host / JNDI).
     *
     * @param emailAddress address of recipient.
     * @param subject      subject header.
     *                     Will be appended with the configured mail subject prefix in the final email.
     * @param body         email body html.
     * @param plainText    plainText alternative to the html body text specified in {@code body}
     * @throws MailSendException an error occured sending the email.
     */
    void sendHtmlEmail(InternetAddress emailAddress, String subject, String body, String plainText) throws MailSendException;

    /**
     * Sends an email using the configured mail server (remote host / JNDI).
     *
     * @param emailAddress address of recipient.
     * @param subject      subject header.
     *                     Will be appended with the configured mail subject prefix in the final email.
     * @param body         email body text.
     * @throws MailSendException an error occured sending the email.
     */
    void sendPlainTextEmail(InternetAddress emailAddress, String subject, String body) throws MailSendException;

    /**
     * @return <code>true</code> if the mail server is fully configured (does not check if the configuration is correct)
     */
    boolean isConfigured();
}
