/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.rest.service.util;

import com.atlassian.crowd.model.token.Token;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.Validate;

public class AuthenticatedApplicationUtil {
    public static final String APPLICATION_NAME_ATTRIBUTE_KEY = "com.atlassian.crowd.authenticated.application.name";
    public static final String APPLICATION_TOKEN_ATTRIBUTE_KEY = "com.atlassian.crowd.authenticated.application.token";

    private AuthenticatedApplicationUtil() {
    }

    @Nullable
    public static String getAuthenticatedApplication(HttpServletRequest request) {
        Validate.notNull((Object)request);
        HttpSession session = request.getSession(false);
        if (session == null) {
            return null;
        }
        Object value = session.getAttribute(APPLICATION_NAME_ATTRIBUTE_KEY);
        return value instanceof String ? (String)value : null;
    }

    public static void setAuthenticatedApplication(HttpServletRequest request, String applicationName) {
        Validate.notNull((Object)request);
        Validate.notNull((Object)applicationName);
        request.getSession().setAttribute(APPLICATION_NAME_ATTRIBUTE_KEY, (Object)applicationName);
    }

    @Nullable
    public static Token getAuthenticatedApplicationToken(HttpServletRequest request) {
        Validate.notNull((Object)request);
        HttpSession session = request.getSession(false);
        if (session == null) {
            return null;
        }
        Object value = session.getAttribute(APPLICATION_TOKEN_ATTRIBUTE_KEY);
        return value instanceof Token ? (Token)value : null;
    }

    public static void setAuthenticatedApplicationToken(HttpServletRequest request, Token token) {
        Validate.notNull((Object)request);
        Validate.notNull((Object)token);
        request.getSession().setAttribute(APPLICATION_TOKEN_ATTRIBUTE_KEY, (Object)token);
    }
}

