/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.rest.service.controller;

import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.manager.application.ApplicationService;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.plugin.rest.service.controller.AbstractResourceController;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.NullRestriction;
import com.atlassian.crowd.search.query.entity.restriction.NullRestrictionImpl;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import java.io.IOException;
import java.io.OutputStream;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.StreamingOutput;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class MembershipsController
extends AbstractResourceController {
    public MembershipsController(ApplicationService applicationService, ApplicationManager applicationManager) {
        super(applicationService, applicationManager);
    }

    public StreamingOutput searchGroups(String applicationName) {
        return new OutputAsXml(applicationName);
    }

    void writeXmlToStream(String applicationName, OutputStream output) throws IOException, XMLStreamException {
        Application application = this.getApplication(applicationName);
        XMLStreamWriter sw = XMLOutputFactory.newInstance().createXMLStreamWriter(output, "utf-8");
        sw.writeStartDocument("utf-8", "1.0");
        sw.writeCharacters("\n");
        sw.writeStartElement("memberships");
        sw.writeCharacters("\n");
        NullRestriction searchRestriction = NullRestrictionImpl.INSTANCE;
        EntityQuery entityQuery = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)searchRestriction).startingAt(0).returningAtMost(-1);
        for (String groupName : this.applicationService.searchGroups(application, entityQuery)) {
            sw.writeCharacters(" ");
            sw.writeStartElement("membership");
            sw.writeAttribute("group", groupName);
            sw.writeCharacters("\n");
            sw.writeCharacters("  ");
            sw.writeStartElement("users");
            sw.writeCharacters("\n");
            MembershipQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(groupName).startingAt(0).returningAtMost(-1);
            for (String user : this.applicationService.searchDirectGroupRelationships(application, query)) {
                sw.writeCharacters("   ");
                sw.writeEmptyElement("user");
                sw.writeAttribute("name", user);
                sw.writeCharacters("\n");
            }
            sw.writeCharacters("  ");
            sw.writeEndElement();
            sw.writeCharacters("\n");
            sw.writeCharacters("  ");
            sw.writeStartElement("groups");
            sw.writeCharacters("\n");
            MembershipQuery query2 = QueryBuilder.createMembershipQuery((int)-1, (int)0, (boolean)true, (EntityDescriptor)EntityDescriptor.group(), String.class, (EntityDescriptor)EntityDescriptor.group(), (String)groupName);
            for (String childGroup : this.applicationService.searchDirectGroupRelationships(application, query2)) {
                sw.writeCharacters("   ");
                sw.writeEmptyElement("group");
                sw.writeAttribute("name", childGroup);
                sw.writeCharacters("\n");
            }
            sw.writeCharacters("  ");
            sw.writeEndElement();
            sw.writeCharacters("\n");
            sw.writeCharacters(" ");
            sw.writeEndElement();
            sw.writeCharacters("\n");
        }
        sw.writeEndElement();
        sw.writeEndDocument();
        sw.close();
    }

    class OutputAsXml
    implements StreamingOutput {
        private final String applicationName;

        public OutputAsXml(String applicationName) {
            this.applicationName = applicationName;
        }

        public void write(OutputStream output) throws IOException, WebApplicationException {
            try {
                MembershipsController.this.writeXmlToStream(this.applicationName, output);
            }
            catch (XMLStreamException e) {
                throw new WebApplicationException((Throwable)e);
            }
        }
    }
}

