/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.rest.filter;

import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidTokenException;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.manager.authentication.TokenAuthenticationManager;
import com.atlassian.crowd.manager.validation.ClientValidationException;
import com.atlassian.crowd.manager.validation.ClientValidationManager;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.authentication.ApplicationAuthenticationContext;
import com.atlassian.crowd.model.authentication.ValidationFactor;
import com.atlassian.crowd.model.token.Token;
import com.atlassian.crowd.plugin.rest.filter.AbstractBasicAuthenticationFilter;
import com.atlassian.crowd.plugin.rest.service.util.AuthenticatedApplicationUtil;
import java.io.IOException;
import javax.annotation.Nullable;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicApplicationAuthenticationFilter
extends AbstractBasicAuthenticationFilter {
    private static final String APPLICATION_AUTHENTICATION_ERROR_MSG = "Application failed to authenticate";
    private static final Logger LOG = LoggerFactory.getLogger(BasicApplicationAuthenticationFilter.class);
    private final ApplicationManager applicationManager;
    private final ClientValidationManager clientValidationManager;
    private final TokenAuthenticationManager tokenAuthenticationManager;

    public BasicApplicationAuthenticationFilter(ApplicationManager applicationManager, ClientValidationManager clientValidationManager, TokenAuthenticationManager tokenAuthenticationManager) {
        this.applicationManager = applicationManager;
        this.clientValidationManager = clientValidationManager;
        this.tokenAuthenticationManager = tokenAuthenticationManager;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        this.ensureSeraphForwardsRequest(servletRequest);
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        AbstractBasicAuthenticationFilter.Credentials credentials = this.getBasicAuthCredentials(request);
        if (credentials == null) {
            LOG.debug("No basic auth credentials found in request, responding with authentication challenge");
            this.respondWithChallenge(response);
        } else {
            try {
                Application application = this.applicationManager.findByName(credentials.getName());
                this.clientValidationManager.validate(application, request);
                if (this.isAuthenticated(request, credentials)) {
                    LOG.debug("Application '{}' is already authenticated", (Object)credentials.getName());
                    chain.doFilter((ServletRequest)request, servletResponse);
                } else {
                    Token token = this.authenticate(application, credentials.getPassword());
                    LOG.debug("Application '{}' authenticated successfully", (Object)credentials.getName());
                    this.setAuthenticatedEntity(request, credentials.getName());
                    if (token != null) {
                        HttpSessionAwareToken tokenThatExpires = new HttpSessionAwareToken(token);
                        AuthenticatedApplicationUtil.setAuthenticatedApplicationToken(request, tokenThatExpires);
                    }
                    chain.doFilter((ServletRequest)request, servletResponse);
                }
            }
            catch (ApplicationNotFoundException e) {
                LOG.info("Application '{}' failed authentication", (Object)credentials.getName());
                this.respondWithChallenge(response);
            }
            catch (InvalidAuthenticationException e) {
                LOG.info("Invalid authentication for application with name '{}'", (Object)credentials.getName());
                this.respondWithChallenge(response);
            }
            catch (ClientValidationException e) {
                response.sendError(403, e.getMessage());
            }
        }
    }

    @Nullable
    private Token authenticate(Application application, String password) throws ClientValidationException, InvalidAuthenticationException, ApplicationNotFoundException {
        ApplicationAuthenticationContext authenticationContext = new ApplicationAuthenticationContext(application.getName(), PasswordCredential.unencrypted((String)password), new ValidationFactor[0]);
        Token token = this.tokenAuthenticationManager.authenticateApplication(authenticationContext);
        if (token == null && !this.applicationManager.authenticate(application, PasswordCredential.unencrypted((String)password))) {
            throw InvalidAuthenticationException.newInstanceWithName((String)application.getName());
        }
        return token;
    }

    protected boolean isAuthenticated(HttpServletRequest request, AbstractBasicAuthenticationFilter.Credentials credentials) {
        Token token = AuthenticatedApplicationUtil.getAuthenticatedApplicationToken(request);
        if (token != null) {
            try {
                this.tokenAuthenticationManager.validateApplicationToken(token.getRandomHash(), new ValidationFactor[0]);
            }
            catch (InvalidTokenException e) {
                return false;
            }
        }
        return super.isAuthenticated(request, credentials);
    }

    protected String getAuthenticatedEntity(HttpServletRequest request) {
        return AuthenticatedApplicationUtil.getAuthenticatedApplication(request);
    }

    protected void setAuthenticatedEntity(HttpServletRequest request, String name) {
        AuthenticatedApplicationUtil.setAuthenticatedApplication(request, name);
    }

    protected String getEntityAttributeKey() {
        return "com.atlassian.crowd.authenticated.application.name";
    }

    protected String getAuthenticationErrorMessage() {
        return APPLICATION_AUTHENTICATION_ERROR_MSG;
    }

    protected String getBasicRealm() {
        return "Crowd REST Service";
    }

    private class HttpSessionAwareToken
    extends Token
    implements HttpSessionBindingListener {
        public HttpSessionAwareToken(Token token) {
            super(token);
        }

        public void valueBound(HttpSessionBindingEvent event) {
        }

        public void valueUnbound(HttpSessionBindingEvent event) {
            LOG.debug("Invalidating application token due to REST HTTP session expiration: " + this.getRandomHash());
            BasicApplicationAuthenticationFilter.this.tokenAuthenticationManager.invalidateToken(this.getRandomHash());
        }
    }
}

