/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin;

import com.atlassian.plugin.hostcontainer.HostContainer;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import org.apache.log4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrowdHostContainer
implements HostContainer,
ApplicationContextAware {
    private ApplicationContext applicationContext;
    private final Logger log = Logger.getLogger(this.getClass());

    public <T> T create(Class<T> tClass) throws IllegalArgumentException {
        for (Constructor<?> constructor : tClass.getConstructors()) {
            if (constructor.getParameterTypes().length != 0 || constructor.getAnnotation(Deprecated.class) != null) continue;
            return tClass.cast(this.applicationContext.getAutowireCapableBeanFactory().createBean(tClass, 1, false));
        }
        return tClass.cast(this.applicationContext.getAutowireCapableBeanFactory().createBean(tClass, 3, false));
    }

    public <T> T getInstance(Class<T> tClass) {
        Object[] componentNames = this.applicationContext.getBeanNamesForType(tClass);
        if (componentNames.length == 1) {
            return tClass.cast(this.applicationContext.getBean(componentNames[0]));
        }
        this.log.warn((Object)("Unable to determine best bean of type " + tClass.getName() + " from beans: " + Arrays.toString(componentNames)));
        return null;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

