package com.atlassian.crowd.util.persistence;

import com.atlassian.crowd.exception.OperationFailedException;

import java.sql.Connection;

public interface SchemaHelper {
    /**
     * If there are any updates to the Schema needed, do them.
     */
    void updateSchemaIfNeeded() throws OperationFailedException;

    /**
     * Creates the schema in the database. This will try to drop and create the schema.
     */
    void createSchema() throws OperationFailedException;

    boolean databaseContainsExistingData(Connection connection);
}