package com.atlassian.crowd.model.sso;

import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.ApplicationImpl;

import java.util.Objects;

public class ApplicationSamlConfigurationEntity {

    private Long applicationId;
    private ApplicationImpl application;
    private Boolean enabled;
    private String assertionConsumerServiceUrl;
    private String audienceUrl;
    private NameIdFormat nameIdFormat;
    private boolean addUserAttributesEnabled;

    ApplicationSamlConfigurationEntity() {
    }

    public ApplicationSamlConfigurationEntity(Application application) {
        this.application = ApplicationImpl.convertIfNeeded(application);
    }

    public ApplicationSamlConfigurationEntity(Application application, Boolean enabled, String assertionConsumerServiceUrl,
                                              String audienceUrl, NameIdFormat nameIdFormat, boolean addUserAttributesEnabled) {
        this.application = ApplicationImpl.convertIfNeeded(application);
        this.enabled = enabled;
        this.assertionConsumerServiceUrl = assertionConsumerServiceUrl;
        this.audienceUrl = audienceUrl;
        this.nameIdFormat = nameIdFormat;
        this.addUserAttributesEnabled = addUserAttributesEnabled;
    }

    public Long getApplicationId() {
        return applicationId;
    }

    public void setApplicationId(Long applicationId) {
        this.applicationId = applicationId;
    }

    public ApplicationImpl getApplication() {
        return application;
    }

    public void setApplication(ApplicationImpl application) {
        this.application = application;
    }

    public Boolean getEnabled() {
        return enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public String getAssertionConsumerServiceUrl() {
        return assertionConsumerServiceUrl;
    }

    public void setAssertionConsumerServiceUrl(String assertionConsumerServiceUrl) {
        this.assertionConsumerServiceUrl = assertionConsumerServiceUrl;
    }

    public String getAudienceUrl() {
        return audienceUrl;
    }

    public void setAudienceUrl(String audienceUrl) {
        this.audienceUrl = audienceUrl;
    }

    public NameIdFormat getNameIdFormat() {
        return nameIdFormat;
    }

    public void setNameIdFormat(NameIdFormat nameIdFormat) {
        this.nameIdFormat = nameIdFormat;
    }

    public boolean isAddUserAttributesEnabled() {
        return addUserAttributesEnabled;
    }

    public void setAddUserAttributesEnabled(boolean addUserAttributesEnabled) {
        this.addUserAttributesEnabled = addUserAttributesEnabled;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ApplicationSamlConfigurationEntity that = (ApplicationSamlConfigurationEntity) o;
        return Objects.equals(applicationId, that.applicationId) &&
                Objects.equals(application, that.application) &&
                Objects.equals(enabled, that.enabled) &&
                Objects.equals(assertionConsumerServiceUrl, that.assertionConsumerServiceUrl) &&
                Objects.equals(audienceUrl, that.audienceUrl) &&
                Objects.equals(nameIdFormat, that.nameIdFormat) &&
                Objects.equals(addUserAttributesEnabled, that.addUserAttributesEnabled);
    }

    @Override
    public int hashCode() {
        return Objects.hash(applicationId, application, enabled, assertionConsumerServiceUrl, audienceUrl, nameIdFormat,
                addUserAttributesEnabled);
    }
}
