package com.atlassian.crowd.model.property;

import java.io.Serializable;

public class PropertyId implements Serializable {
    private String key;
    private String name;

    protected PropertyId() {

    }

    public PropertyId(final String key, final String name) {
        this.key = key;
        this.name = name;
    }

    public String getKey() {
        return key;
    }

    public void setKey(final String key) {
        this.key = key;
    }

    public String getName() {
        return name;
    }

    public void setName(final String name) {
        this.name = name;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) return true;
        if (!(o instanceof PropertyId)) return false;

        PropertyId that = (PropertyId) o;

        if (key != null ? !key.equals(that.key) : that.key != null) return false;
        if (name != null ? !name.equals(that.name) : that.name != null) return false;

        return true;
    }

    @Override
    public int hashCode() {
        int result = key != null ? key.hashCode() : 0;
        result = 31 * result + (name != null ? name.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "PropertyId{" +
                "key='" + key + '\'' +
                ", name='" + name + '\'' +
                '}';
    }
}
