package com.atlassian.crowd.model.cluster;

import javax.annotation.Nullable;
import java.util.Objects;

public class ClusterSafetyEntity {
    private String key;
    private String value;
    private String nodeId;
    private String ipAddress;
    private long timestamp;

    protected ClusterSafetyEntity() {
    }

    public ClusterSafetyEntity(String key, String value, String nodeId, String ipAddress, long timestamp) {
        this.key = key;
        this.value = value;
        this.nodeId = nodeId;
        this.ipAddress = ipAddress;
        this.timestamp = timestamp;
    }

    public String getKey() {
        return key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Nullable
    public String getNodeId() {
        return nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    @Nullable
    public String getIpAddress() {
        return ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public long getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ClusterSafetyEntity that = (ClusterSafetyEntity) o;
        return timestamp == that.timestamp &&
                Objects.equals(key, that.key) &&
                Objects.equals(value, that.value) &&
                Objects.equals(nodeId, that.nodeId) &&
                Objects.equals(ipAddress, that.ipAddress);
    }

    @Override
    public int hashCode() {
        return Objects.hash(key, value, nodeId, ipAddress, timestamp);
    }
}