package com.atlassian.crowd.model.application;

import java.time.Instant;
import java.util.Objects;

/**
 * Results of scan which iterates over users in a given application and finds invalid and duplicated email addresses.
 */
public class AppIssuesWithMailScanResultEntity {
    private long appId;
    private Instant scanTimestamp;
    private long invalidEmailsCount;
    private long duplicatedEmailsCount;

    public AppIssuesWithMailScanResultEntity() {
    }

    public AppIssuesWithMailScanResultEntity(long appId, Instant scanTimestamp, long invalidEmailsCount, long duplicatedEmailsCount) {
        this.appId = appId;
        this.scanTimestamp = scanTimestamp;
        this.invalidEmailsCount = invalidEmailsCount;
        this.duplicatedEmailsCount = duplicatedEmailsCount;
    }

    public long getAppId() {
        return appId;
    }

    public void setAppId(long appId) {
        this.appId = appId;
    }

    public Instant getScanTimestamp() {
        return scanTimestamp;
    }

    public void setScanTimestamp(Instant scanTimestamp) {
        this.scanTimestamp = scanTimestamp;
    }

    public long getInvalidEmailsCount() {
        return invalidEmailsCount;
    }

    public void setInvalidEmailsCount(long invalidEmailsCount) {
        this.invalidEmailsCount = invalidEmailsCount;
    }

    public long getDuplicatedEmailsCount() {
        return duplicatedEmailsCount;
    }

    public void setDuplicatedEmailsCount(long duplicatedEmailsCount) {
        this.duplicatedEmailsCount = duplicatedEmailsCount;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        AppIssuesWithMailScanResultEntity that = (AppIssuesWithMailScanResultEntity) o;
        return appId == that.appId &&
                invalidEmailsCount == that.invalidEmailsCount &&
                duplicatedEmailsCount == that.duplicatedEmailsCount &&
                scanTimestamp.getEpochSecond() == that.scanTimestamp.getEpochSecond();
    }

    @Override
    public int hashCode() {
        return Objects.hash(appId, scanTimestamp.getEpochSecond(), invalidEmailsCount, duplicatedEmailsCount);
    }
}
