package com.atlassian.crowd.directory;

import java.util.regex.Pattern;

import com.atlassian.crowd.embedded.api.PasswordConstraint;
import com.atlassian.crowd.embedded.api.ValidatePasswordRequest;
import org.apache.commons.lang3.StringUtils;

import static com.google.common.base.Preconditions.checkNotNull;

public class RegexConstraint implements PasswordConstraint {
    private final String regex;

    /**
     * @param regex a regular expression the password must match
     */
    public RegexConstraint(String regex) {
        this.regex = checkNotNull(regex);
    }

    public String getRegex() {
        return regex;
    }

    @Override
    public boolean validate(ValidatePasswordRequest request) {
        return StringUtils.isBlank(regex) || Pattern.compile(regex).matcher(request.getPassword().getCredential()).find();
    }

    @Override
    public String toString() {
        return "PasswordRegexConstraint[regex@" + regex.hashCode() + "]";
    }
}
