package com.atlassian.crowd.dao.licensing;

import com.atlassian.crowd.exception.ObjectNotFoundException;
import com.atlassian.crowd.model.licensing.LicensedUser;
import com.atlassian.crowd.model.licensing.LicensingSummary;

import java.util.List;

/**
 * Data access object for {@link com.atlassian.crowd.model.licensing.LicensedUser}
 */
public interface LicensedUserDao {
    LicensedUser findById(long id) throws ObjectNotFoundException;
    void update(LicensedUser licensedUser);

    void save(List<LicensedUser> licensedUsers);

    void remove(LicensedUser licensedUser);
    List<LicensedUser> findLicensedUsers(LicensedUsersQuery query);

    Long countLicensedUsers(LicensedUsersQuery query);

    void removeAll(LicensingSummary licensingSummary);

    void removeByDirectoryId(Long id);
}
