package com.atlassian.crowd.util.persistence.hibernate.batch;

import com.atlassian.crowd.model.audit.AuditLogChangesetEntity;

import java.util.Collection;
import java.util.List;
import java.util.function.Function;

/**
 * Allows mapping a collection of entities processes by a {@link com.atlassian.crowd.util.persistence.hibernate.batch.BatchProcessor}
 * to a list of audit log changesets, to be persisted to generate an audit trail for the operation.
 */
@FunctionalInterface
public interface BulkAuditMapper<T> extends Function<Collection<T>, List<AuditLogChangesetEntity>> {
}