package com.atlassian.crowd.util;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ExceptionUtils {

    /**
     * Gets the message of throwable with striping out characters which cannot be legally represented in DB.
     *
     * @param t the throwable to get a message for
     * @return the message
     */
    @Nonnull
    public static String getMessageWithValidDbCharacters(@Nullable Throwable t) {
        String message = org.apache.commons.lang3.exception.ExceptionUtils.getMessage(t);
        return message.replace("\u0000", ""); // e.g. LDAP can return \0 (00x0) character that cannot be persisted in DB (CWD-5806)
    }

    private ExceptionUtils() {
    }
}
