package com.atlassian.crowd.search.hibernate.audit;

import com.google.common.base.Strings;

import java.util.List;
import java.util.stream.Collectors;

public abstract class RestrictionCollection implements Restriction {

    protected final List<Restriction> restrictions;

    public RestrictionCollection(List<Restriction> restrictions) {
        this.restrictions = restrictions.stream().filter(clause -> !(clause instanceof EmptyRestriction)).collect(Collectors.toList());
    }

    @Override
    public String getFrom() {
        return restrictions.stream().map(Restriction::getFrom).filter(from -> !Strings.isNullOrEmpty(from)).collect(Collectors.joining(" "));
    }
}
