package com.atlassian.crowd.model.user;

import com.google.common.base.MoreObjects;

import java.time.Instant;
import java.util.Objects;

public class InternalUserWithPasswordLastChanged {
    private InternalUser user;
    private Instant passwordLastChanged;

    public InternalUserWithPasswordLastChanged(InternalUser user, Instant passwordLastChanged) {
        this.user = user;
        this.passwordLastChanged = passwordLastChanged;
    }

    public InternalUserWithPasswordLastChanged(InternalUser user, long passwordLastChangedInMillis) {
        this.user = user;
        this.passwordLastChanged = Instant.ofEpochMilli(passwordLastChangedInMillis);
    }

    public String getDisplayName() {
        return user.getDisplayName();
    }

    public String getEmailAddress() {
        return user.getEmailAddress();
    }

    public InternalUser getUser() {
        return user;
    }

    public Instant getPasswordLastChanged() {
        return passwordLastChanged;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        InternalUserWithPasswordLastChanged that = (InternalUserWithPasswordLastChanged) o;
        return Objects.equals(user, that.user) &&
                Objects.equals(passwordLastChanged, that.passwordLastChanged);
    }

    @Override
    public int hashCode() {
        return Objects.hash(user, passwordLastChanged);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("user", user)
                .add("passwordLastChanged", passwordLastChanged)
                .toString();
    }
}
