package com.atlassian.crowd.model.tombstone;

import javax.annotation.Nullable;

import com.google.common.base.MoreObjects;

/**
 * Used as a marker to indicate that a changed happened, that prevents creating an event stream from before the
 * tombstone timestamp, either for the specific directory, or for the entire instance
 */
public class EventStreamTombstone extends AbstractTombstone {
    private String reason;
    @Nullable
    private Long directoryId;

    protected EventStreamTombstone() {
    }

    public static EventStreamTombstone createGlobal(long timestamp, String reason) {
        return new EventStreamTombstone(timestamp, reason, null);
    }

    public static EventStreamTombstone createForDirectory(long timestamp, long directoryId, String reason) {
        return new EventStreamTombstone(timestamp, reason, directoryId);
    }

    public EventStreamTombstone(long timestamp, String reason, @Nullable Long directoryId) {
        super(timestamp);
        this.reason = reason;
        this.directoryId = directoryId;
    }

    public String getReason() {
        return reason;
    }

    protected void setReason(String reason) {
        this.reason = reason;
    }

    @Nullable
    public Long getDirectoryId() {
        return directoryId;
    }

    protected void setDirectoryId(@Nullable Long directoryId) {
        this.directoryId = directoryId;
    }


    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("id", getId())
                .add("timestamp", getTimestamp())
                .add("reason", reason)
                .add("directoryId", directoryId)
                .toString();
    }
}