package com.atlassian.crowd.model.tombstone;

/**
 * Used as a marker for all alias changes, not only deletions. This is because aliases currently don't have a
 * created/updated date stored, and the events produced are only used to invalidate the entire stream by
 * com.atlassian.crowd.manager.application.TranslatingApplicationService#getNewEvents
 */
public class AliasTombstone extends ApplicationTombstone {
    private String username;

    protected AliasTombstone() {
    }

    public AliasTombstone(long timestamp, long applicationId, String username) {
        super(timestamp, applicationId);
        this.username = username;
    }

    public String getUsername() {
        return username;
    }

    protected void setUsername(String username) {
        this.username = username;
    }
}