package com.atlassian.crowd.model.scheduling;

import java.util.Date;

/**
 * Describes a scheduled, once-per-cluster job as saved in Crowd's database.
 * Designed for easy conversion to com.atlassian.scheduler.caesium.spi.ClusteredJob.
 */
public class InternalClusterJob {
    private String id;
    private String runnerKey;

    private String timeZone;
    private String cronExpression;
    private Long interval;

    private Date nextRunTime;
    private long version;
    private byte[] rawParameters;

    private String claimNodeId;
    private Date claimTime;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRunnerKey() {
        return runnerKey;
    }

    public void setRunnerKey(String runnerKey) {
        this.runnerKey = runnerKey;
    }

    public String getTimeZone() {
        return timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public String getCronExpression() {
        return cronExpression;
    }

    public void setCronExpression(String cronExpression) {
        this.cronExpression = cronExpression;
    }

    public Long getInterval() {
        return interval;
    }

    public void setInterval(Long interval) {
        this.interval = interval;
    }

    public Date getNextRunTime() {
        return nextRunTime;
    }

    public void setNextRunTime(Date nextRunDate) {
        this.nextRunTime = nextRunDate;
    }


    public Long getNextRunTimestamp() {
        return nextRunTime == null ? null : nextRunTime.getTime();
    }

    public void setNextRunTimestamp(Long millisTimestamp) {
        this.nextRunTime = millisTimestamp == null ? null : new java.util.Date(millisTimestamp);
    }

    public long getVersion() {
        return version;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public byte[] getRawParameters() {
        return rawParameters;
    }

    public void setRawParameters(byte[] rawParameters) {
        this.rawParameters = rawParameters;
    }

    public String getClaimNodeId() {
        return claimNodeId;
    }

    public void setClaimNodeId(String claimNodeId) {
        this.claimNodeId = claimNodeId;
    }

    public Long getClaimTimestamp() {
        return claimTime == null ? null : claimTime.getTime();
    }

    public void setClaimTimestamp(Long millisTimestamp) {
        this.claimTime = millisTimestamp == null ? null : new java.util.Date(millisTimestamp);
    }

    public Date getClaimTime() {
        return claimTime;
    }

    public void setClaimTime(Date claimTime) {
        this.claimTime = claimTime;
    }
}
