package com.atlassian.crowd.model.property;

import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.ToStringBuilder;

import java.io.Serializable;

/**
 * Captures various server properties of the crowd server.
 */
public class Property implements Serializable {
    /**
     * Parent Property Key for all Crowd Server properties.
     */
    public static final String CROWD_PROPERTY_KEY = "crowd";

    /**
     * Server Property: Cache time.
     */
    public static final String CACHE_TIME = "cache.time";

    /**
     * Server Property: Custom token seed.
     */
    public static final String TOKEN_SEED = "token.seed";

    /**
     * Server Property: Deployment title.
     */
    public static final String DEPLOYMENT_TITLE = "deployment.title";

    /**
     * Server Property: Deployment domain.
     */
    public static final String DOMAIN = "domain";

    /**
     * Server Property: Cache enabled.
     */
    public static final String CACHE_ENABLED = "cache.enabled";

    /**
     * Server Property: Session time;
     */
    public static final String SESSION_TIME = "session.time";

    /**
     * Server Property: Mail server host.
     */
    public static final String MAILSERVER_HOST = "mailserver.host";

    /**
     * Server Property: Mail server prefix.
     */
    public static final String MAILSERVER_PREFIX = "mailserver.prefix";

    /**
     * Server Property: Mail server sender.
     */
    public static final String MAILSERVER_SENDER = "mailserver.sender";

    /**
     * Server Property: Mail server username.
     */
    public static final String MAILSERVER_USERNAME = "mailserver.username";

    /**
     * Server Property: Mail server password.
     */
    public static final String MAILSERVER_PASSWORD = "mailserver.password";

    /**
     * Server Property: Forgotten password email template
     */
    public static final String FORGOTTEN_PASSWORD_EMAIL_TEMPLATE = "mailserver.message.template";

    /**
     * Server Property: Forgotten usernames email template
     */
    public static final String FORGOTTEN_USERNAME_EMAIL_TEMPLATE = "email.template.forgotten.username";

    /**
     * Server Property: Password expiration reminder email template
     */
    public static final String PASSWORD_EXPIRATION_REMINDER_EMAIL_TEMPLATE = "email.template.password.expiration.reminder";

    /**
     * Server Property: Server encryption key.
     */
    public static final String DES_ENCRYPTION_KEY = "des.encryption.key";

    /**
     * Server Property: Total number of 'current' resources towards the license resource limit, ie number of users.
     */
    public static final String CURRENT_LICENSE_RESOURCE_TOTAL = "current.license.resource.total";

    /**
     * Server Property: Email address for the administrator when server notifications occur.
     */
    public static final String NOTIFICATION_EMAIL = "notification.email";

    /**
     * Server Property: The current build number for Crowd.
     */
    public static final String BUILD_NUMBER = "build.number";

    /**
     * Server Property: True if GZip compression is enabled on the response.
     */
    @Deprecated
    public static final String GZIP_ENABLED = "gzip.enabled";

    /**
     * Server Property: A comma-delimited list of trusted proxy servers.
     */
    public static final String TRUSTED_PROXY_SERVERS = "trusted.proxy.servers";

    /**
     * Server Property: Whether or not Crowd is using database token storage
     */
    public static final String DATABASE_TOKEN_STORAGE_ENABLED = "database.token.storage.enabled";

    /**
     * Server Property: Whether or not to use a public service for avatars
     */
    public static final String USE_WEB_AVATARS = "webavatars.enabled";

    /**
     * Server Property: Mail Server JNDI Location
     */
    public static final String MAILSERVER_JNDI_LOCATION = "mailserver.jndi";
    /**
     * Server Property: Mail Server START TLS Option
     */
    public static final String MAILSERVER_START_TLS  = "mailserver.startTLS";
    /**
     * Server Property: Mail Server SMTP port
     */
    public static final String MAILSERVER_PORT = "mailserver.port";

    /**
     * Server Property: Mail Server SMTP read and connection timeout
     */
    public static final String MAILSERVER_TIMEOUT = "mailserver.timeout";

    /**
     * Server Property: Mail Server SMTP Use SSL
     */
    public static final String MAILSERVER_USE_SSL = "mailserver.usessl";

    public static final String INCLUDE_IP_ADDRESS_IN_VALIDATION_FACTORS = "validation.factors.include_ip_address";

    /**
     * Server Property: SSO Cookie set to "Secure"
     */
    public static final String SECURE_COOKIE = "secure.cookie";

    /**
     * Server Property: SSO cookie name, used to be "cookie.tokenkey" in crowd.properties
     * @since 3.0
     */
    public static final String SSO_COOKE_NAME_PROPERTY = "cookie.tokenkey";

    /**
     * The base URL for the Crowd application
     * @since 3.0
     */
    public static final String CROWD_BASE_URL = "base.url";

    /**
     * Server Property: Audit log retention period in days
     */
    public static final String AUDIT_LOG_RETENTION_PERIOD = "audit.log.retention.period";

    /**
     * Server Property: ID of private key/certificate pair used to sign assertions in SAML
     */
    public static final String SAML_KEY_CERTIFICATE_PAIR_TO_SIGN = "saml.key.certificate.pair.id";

    /**
     * Server Property: Determines if Remember Me is enabled
     */
    public static final String REMEMBER_ME_ENABLED_PROPERTY_NAME = "rememberme.enabled";

    /**
     * Server Property: Remember Me tokens validity duration expressed in seconds
     */
    public static final String REMEMBER_ME_EXPIRY_IN_SECONDS_PROPERTY_NAME = "rememberme.duration";

    /**
     * Server Property: Whether or not to perform automated backup
     */
    public static final String SCHEDULED_BACKUP_ENABLED = "backup.scheduled.enabled";

    /**
     * Server Property: Whether or not to export users from connectors during backup
     */
    public static final String EXPORT_USERS_FROM_CONNECTORS_DURING_BACKUP_ENABLED = "backup.export.users.from.connector.enabled";

    /**
     * Server Property: Whether or not to save the backup with the SSO domain information
     */
    public static final String RESET_DOMAIN_FOR_BACKUP_ENABLED = "backup.reset.domain.enabled";

    /**
     * Server property: Determines hour of the day when automated backup is performed
     */
    public static final String BACKUP_SCHEDULED_TIME_HOUR = "backup.scheduled.time.hour";

    /**
     * Server property: Determines minute of the hour when automated backup is performed
     */
    public static final String BACKUP_SCHEDULED_TIME_MINUTE = "backup.scheduled.time.minute";

    /**
     * Server Property: Look and feel configuration
     */
    public static final String LOOK_AND_FEEL_CONFIGURATION_PROPERTY_NAME = "lookandfeel.configuration";

    public static final String CROWD_DEFAULT_ENCRYPTOR_PROPERTY = "crowd.encryption.encryptor.default";

    private PropertyId propertyId;
    private String value;

    public Property(final String key, final String name, final String value) {
        Validate.notNull(key, "key cannot be null");
        Validate.notNull(key, "name cannot be null");
        Validate.notNull(key, "value cannot be null");
        this.propertyId = new PropertyId();
        this.propertyId.setKey(key);
        this.propertyId.setName(name);
        this.value = value;
    }

    protected Property() {
    }

    private PropertyId getPropertyId() {
        return propertyId;
    }

    private void setPropertyId(final PropertyId propertyId) {
        this.propertyId = propertyId;
    }

    public String getKey() {
        return propertyId.getKey();
    }

    public String getName() {
        return propertyId.getName();
    }

    public String getValue() {
        return value;
    }

    public void setValue(final String value) {
        this.value = value;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) return true;
        if (!(o instanceof Property)) return false;

        Property property = (Property) o;

        if (propertyId != null ? !propertyId.equals(property.propertyId) : property.propertyId != null) return false;
        if (value != null ? !value.equals(property.value) : property.value != null) return false;

        return true;
    }

    @Override
    public int hashCode() {
        int result = propertyId != null ? propertyId.hashCode() : 0;
        result = 31 * result + (value != null ? value.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this).
                append("key", getKey()).
                append("name", getName()).
                append("value", getValue()).
                toString();
    }
}
