package com.atlassian.crowd.model.cluster;

public class InternalClusterMessage {
    private long id; // hibernate only
    private String channel;
    private String text;
    private long timestamp;
    private String senderNodeId;

    protected InternalClusterMessage() {
        // hibernate only
    }

    public InternalClusterMessage(String channel, String text, String senderNodeId, long timestamp) {
        this.channel = channel;
        this.text = text;
        this.senderNodeId = senderNodeId;
        this.timestamp = timestamp;
    }

    public long getId() {
        return id;
    }

    public String getChannel() {
        return channel;
    }

    public String getText() {
        return text;
    }

    public long getTimestamp() {
        return timestamp;
    }

    public String getSenderNodeId() {
        return senderNodeId;
    }

    // hibernate only

    private void setText(String message) {
        this.text = message;
    }

    private void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    private void setChannel(String channel) {
        this.channel = channel;
    }

    private void setSenderNodeId(String senderNodeId) {
        this.senderNodeId = senderNodeId;
    }

    private void setId(long id) {
        this.id = id;
    }
}
