package com.atlassian.crowd.model.audit;

import com.atlassian.crowd.audit.AuditLogEntry;
import com.google.common.base.MoreObjects;

import java.util.Objects;

import static com.google.common.base.Strings.nullToEmpty;

public class AuditLogEntryEntity implements AuditLogEntry {
    private Long id;
    private String propertyName = "";
    private String oldValue = "";
    private String newValue = "";
    private AuditLogChangesetEntity changeset;

    protected AuditLogEntryEntity() {
    }

    public AuditLogEntryEntity(String propertyName, String oldValue, String newValue) {
        this(null, propertyName, oldValue, newValue);
    }

    public AuditLogEntryEntity(Long id, String propertyName, String oldValue, String newValue) {
        this.id = id;
        this.propertyName = nullToEmpty(propertyName);
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    public AuditLogEntryEntity(Long id, String propertyName, String oldValue, String newValue, AuditLogChangesetEntity changeset) {
        this.id = id;
        this.propertyName = propertyName;
        this.oldValue = oldValue;
        this.newValue = newValue;
        this.changeset = changeset;
    }

    public AuditLogEntryEntity(AuditLogEntry auditLogEntry) {
        this(auditLogEntry.getPropertyName(), auditLogEntry.getOldValue(), auditLogEntry.getNewValue());
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getPropertyName() {
        return propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = nullToEmpty(propertyName);
    }

    public String getOldValue() {
        return oldValue;
    }

    public void setOldValue(String oldValue) {
        this.oldValue = oldValue;
    }

    public String getNewValue() {
        return newValue;
    }

    public void setNewValue(String newValue) {
        this.newValue = newValue;
    }

    public AuditLogChangesetEntity getChangeset() {
        return changeset;
    }

    public void setChangeset(AuditLogChangesetEntity changeset) {
        this.changeset = changeset;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        final AuditLogEntryEntity that = (AuditLogEntryEntity) o;
        return Objects.equals(this.getId(), that.getId())
                && Objects.equals(this.getPropertyName(), that.getPropertyName())
                && Objects.equals(this.getOldValue(), that.getOldValue())
                && Objects.equals(this.getNewValue(), that.getNewValue());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getId(), getPropertyName(), getOldValue(), getNewValue());
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("id", id)
                .add("propertyName", propertyName)
                .add("oldValue", oldValue)
                .add("newValue", newValue)
                .toString();
    }
}
