package com.atlassian.crowd.directory;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.OperationType;

import javax.annotation.Nullable;
import java.util.Date;
import java.util.Map;
import java.util.Set;

public abstract class DirectoryWrapper implements Directory {
    protected Directory delegate;

    public DirectoryWrapper(Directory delegate) {
        this.delegate = delegate;
    }

    @Nullable
    @Override
    public Set<String> getValues(String key) {
        return delegate.getValues(key);
    }

    @Nullable
    @Override
    public String getValue(String key) {
        return delegate.getValue(key);
    }

    @Override
    public Set<String> getKeys() {
        return delegate.getKeys();
    }

    @Override
    public boolean isEmpty() {
        return delegate.isEmpty();
    }

    @Override
    public Long getId() {
        return delegate.getId();
    }

    @Override
    public String getName() {
        return delegate.getName();
    }

    @Override
    public boolean isActive() {
        return delegate.isActive();
    }

    @Override
    public String getEncryptionType() {
        return delegate.getEncryptionType();
    }

    @Override
    public Map<String, String> getAttributes() {
        return delegate.getAttributes();
    }

    @Override
    public Set<OperationType> getAllowedOperations() {
        return delegate.getAllowedOperations();
    }

    @Override
    public String getDescription() {
        return delegate.getDescription();
    }

    @Override
    public DirectoryType getType() {
        return delegate.getType();
    }

    @Override
    public String getImplementationClass() {
        return delegate.getImplementationClass();
    }

    @Override
    public Date getCreatedDate() {
        return delegate.getCreatedDate();
    }

    @Override
    public Date getUpdatedDate() {
        return delegate.getUpdatedDate();
    }

    @Override
    public boolean isPersistable() {
        return delegate.isPersistable();
    }
}
