package com.atlassian.crowd.directory;

import com.atlassian.crowd.embedded.api.Directory;

import java.util.Objects;

public class DirectorySynchronisationToken {
    private Long directoryId;
    private Directory directory;
    private String synchronisationToken;

    public DirectorySynchronisationToken() {
    }

    public DirectorySynchronisationToken(Directory directory, String synchronisationToken) {
        // only directory is updated as Hibernate should take care of updating the directoryId. It appears that we need
        // both to use the foreign key as a primary key and updating the id manually causes a plethora of odd problems
        this.directory = directory;
        this.synchronisationToken = synchronisationToken;
    }

    public Long getDirectoryId() {
        return directoryId;
    }

    public void setDirectoryId(Long directoryId) {
        this.directoryId = directoryId;
    }

    public Directory getDirectory() {
        return directory;
    }

    public void setDirectory(Directory directory) {
        this.directory = directory;
    }

    public String getSynchronisationToken() {
        return synchronisationToken;
    }

    public void setSynchronisationToken(String synchronisationToken) {
        this.synchronisationToken = synchronisationToken;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        DirectorySynchronisationToken that = (DirectorySynchronisationToken) o;
        return Objects.equals(directoryId, that.directoryId) &&
                Objects.equals(directory, that.directory) &&
                Objects.equals(synchronisationToken, that.synchronisationToken);
    }

    @Override
    public int hashCode() {
        return Objects.hash(directoryId, directory, synchronisationToken);
    }
}
