package com.atlassian.crowd.dao.sso;

import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.sso.ApplicationSamlConfigurationEntity;

import java.util.List;
import java.util.Optional;

/**
 * Allows storing and retrieving application-specific SAML SSO configuration
 */
public interface ApplicationSamlConfigurationDAO {

    /**
     * Returns the SAML SSO configuration for the specified application
     * @param application the application for which the configuration should be fetched
     * @return an optional containing the configuration if present or an empty one if not
     */
    Optional<ApplicationSamlConfigurationEntity> loadForApplication(Application application);

    /**
     * Returns the SAML SSO configuration for the specified assertion consumer url and audience. At least one of the
     * parameters have to be specified to get non-empty result.
     * @param assertionConsumerUrl SSO application assertion consumer url
     * @param audience SSO application audience
     * @return an optional with the corresponding configuration, if any. In case of unspecified parameters an empty Optional will be returned.
     */
    Optional<ApplicationSamlConfigurationEntity> findByAssertionConsumerAndAudience(String assertionConsumerUrl, String audience);

    /**
     * Creates or updates SAML SSO configuration for an application
     * @param configuration the configuration to save or update
     */
    void save(ApplicationSamlConfigurationEntity configuration) throws ApplicationNotFoundException;

    /**
     * Returns list of all configurations.
     */
    List<ApplicationSamlConfigurationEntity> findAll();
}
