package com.atlassian.crowd.dao.permission;

import com.atlassian.crowd.model.group.InternalGroup;
import com.atlassian.crowd.model.permission.UserAdministrationGrantToGroup;
import com.atlassian.crowd.model.user.InternalUser;

import java.util.List;
import java.util.Optional;

/**
 * Manages persistence of group administration grants for users
 * @since 3.3.0
 */
public interface UserAdministrationGrantGroupDao {

    /**
     * Adds a new group administration grant for a user
     * @param grant the grant
     * @return the newly persisted grant
     */
    UserAdministrationGrantToGroup add(UserAdministrationGrantToGroup grant);

    /**
     * Looks for administration grants for a given group
     * @param targetGroup the group
     * @return Grants found for this group
     */
    List<UserAdministrationGrantToGroup> findGrantsToGroup(InternalGroup targetGroup);

    /**
     * Looks for all administration grants a user has
     * @return found grants
     */
    List<UserAdministrationGrantToGroup> findUserGrants(InternalUser internalUser);

    /**
     * Checks if an user has a grant to a group
     * @param internalUser the user
     * @param internalGroup the group
     * @return a mapping, if found any
     */
    Optional<UserAdministrationGrantToGroup> findUserGrantForGroup(InternalUser internalUser, InternalGroup internalGroup);

    /**
     * @return all the group administration grants assigned to users
     */
    List<UserAdministrationGrantToGroup> findAll();

    /**
     * Remove administration grant for a user to a group
     * @param user the user who will lose the grant
     * @param targetGroup the group to which grant will be removed
     */
    void remove(InternalUser user, InternalGroup targetGroup);
}
