package com.atlassian.crowd.dao.permission;

import com.atlassian.crowd.manager.permission.PermittedGroup;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.DirectoryMapping;
import com.atlassian.crowd.model.permission.InternalGrantedPermission;
import com.atlassian.crowd.model.permission.UserPermission;

import java.util.Collection;
import java.util.Collections;
import java.util.List;

/**
 * A no-op implementation of InternalUserPermissionDAO, to be used by products embedding Crowd - these don't use
 * Crowd's permission infrastructure.
 *
 * Most operation behave as if no permissions were granted. Trying to grant permissions throws.
 *
 * @since 2.11
 */
public class NoopInternalUserPermissionDAO implements InternalUserPermissionDAO {
    @Override
    public boolean exists(InternalGrantedPermission permission) {
        return false;
    }

    @Override
    public boolean revoke(InternalGrantedPermission permission) {
        return false;
    }

    @Override
    public int revokeAll(DirectoryMapping directoryMapping) {
        return 0;
    }

    @Override
    public void grant(InternalGrantedPermission permission) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<PermittedGroup> getGrantedPermissions(UserPermission permission) {
        return Collections.emptyList();
    }

    @Override
    public Collection<PermittedGroup> getGrantedPermissions(UserPermission permission, Application application) {
        return Collections.emptyList();
    }

    @Override
    public List<PermittedGroup> findHighestPermissionPerGroupByPrefix(String prefix, int start, int limit) {
        return Collections.emptyList();
    }

    @Override
    public List<PermittedGroup> findHighestPermissionPerGroup(int start, int limit) {
        return Collections.emptyList();
    }

    @Override
    public List<InternalGrantedPermission> findAllPermissionsForGroup(String groupName, long directoryId) {
        return Collections.emptyList();
    }
}