package com.atlassian.crowd.dao.permission;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.model.group.InternalGroup;
import com.atlassian.crowd.model.permission.GroupAdministrationGrantToGroup;

import java.util.Collection;
import java.util.List;

/**
 * Manages persistence of group administration grants for groups
 * @since 3.3.0
 */
public interface GroupAdministrationGrantGroupDao {

    /**
     * Adds a new group administration grant to a group
     * @param grant the grant
     * @return the newly persisted grant
     */
    GroupAdministrationGrantToGroup add(GroupAdministrationGrantToGroup grant);

    /**
     * Looks for administration grants for a given group
     * @param targetGroup the group
     * @return Grants found for this group
     */
    List<GroupAdministrationGrantToGroup> findGrantsToGroup(InternalGroup targetGroup);

    /**
     * Looks for grants assigned to given groups
     * @param groups the groups
     * @return found mappings of groups
     */
    List<GroupAdministrationGrantToGroup> findGrantsOfGroups(Collection<InternalGroup> groups);

    /**
     * Looks for grants of groups which administer an other group and come from given directory
     * @param group the group which is administered
     * @param directory the directory
     * @return found mappings
     */
    List<GroupAdministrationGrantToGroup> findGrantsToGroupFromDirectory(InternalGroup group, Directory directory);

    /**
     * @return all the group administration grants assigned to users
     */
    List<GroupAdministrationGrantToGroup> findAll();

    /**
     * Remove administration grant for a group to a group
     * @param adminGroup the group which will lose the grant
     * @param targetGroup the id of group to which grant will be lost
     */
    void remove(InternalGroup adminGroup, InternalGroup targetGroup);
}
