package com.atlassian.crowd.dao.membership.cache;

import java.io.Serializable;
import java.util.Objects;

/**
 * Cache key for the given {@link QueryType} and directory id.
 */
class QueryTypeCacheKey implements Serializable {
    private final long directoryId;
    private final QueryType queryType;

    public QueryTypeCacheKey(long directoryId, QueryType queryType) {
        this.directoryId = directoryId;
        this.queryType = queryType;
    }

    public long getDirectoryId() {
        return directoryId;
    }

    public QueryType getQueryType() {
        return queryType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        QueryTypeCacheKey cacheKey = (QueryTypeCacheKey) o;
        return directoryId == cacheKey.directoryId &&
                queryType == cacheKey.queryType;
    }

    @Override
    public int hashCode() {
        return Objects.hash(directoryId, queryType);
    }
}
