package com.atlassian.crowd.dao.membership.cache;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheSettingsBuilder;

import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * Default implementation of {@link CacheFactory}.
 * Caches will expire after write, replicate asynchronously and via invalidation.
 */
public class DefaultCacheFactory implements CacheFactory{
    private final com.atlassian.cache.CacheFactory cacheFactory;

    public DefaultCacheFactory(com.atlassian.cache.CacheFactory cacheFactory) {
        this.cacheFactory = cacheFactory;
    }

    @Override
    public Cache<String, List<String>> createCache(QueryTypeCacheKey cacheKey, Duration cacheTtl, int maxEntries) {
        return cacheFactory.getCache("crowd.internal.groupMembership." + cacheKey.getDirectoryId() + "-" + cacheKey.getQueryType(),
                null,
                new CacheSettingsBuilder()
                        .expireAfterWrite(cacheTtl.getSeconds(), TimeUnit.SECONDS)
                        .maxEntries(maxEntries)
                        .remote()
                        .replicateAsynchronously()
                        .replicateViaInvalidation()
                        .build()
        );
    }
}
