package com.atlassian.crowd.dao.direntity;

import com.atlassian.crowd.model.DirectoryEntity;

import javax.annotation.Nullable;
import java.util.Collection;
import java.util.List;

/**
 * Helper interface to resolve entities by name. Allows to de-duplicate entities by name.
 */
public interface DirectoryEntityResolver {
    @Nullable
    <T extends DirectoryEntity> T resolve(long directoryId, String key, Class<T> entityClass);

    <T extends DirectoryEntity> void put(T entity);

    /**
     * Returns list of all entities for the given keys, or null if any of the corresponding entities can't be found.
     */
    @Nullable
    <T extends DirectoryEntity> List<T> resolveAllOrNothing(long directoryId, Collection<String> keys, Class<T> entityClass);

    void putAll(List<? extends DirectoryEntity> entities);
}
