/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory;

import com.atlassian.crowd.directory.PasswordConstraintsLoader;
import com.atlassian.crowd.directory.PasswordLengthConstraint;
import com.atlassian.crowd.directory.PasswordScoreConstraint;
import com.atlassian.crowd.directory.RegexConstraint;
import com.atlassian.crowd.embedded.api.Attributes;
import com.atlassian.crowd.embedded.api.PasswordConstraint;
import com.atlassian.crowd.embedded.api.PasswordScore;
import com.atlassian.crowd.embedded.api.PasswordScoreService;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordConstraintsLoaderImpl
implements PasswordConstraintsLoader {
    @VisibleForTesting
    public static final String PASSWORD_POLICY_FEATURE = "um.password.policy";
    private static final Logger logger = LoggerFactory.getLogger(PasswordConstraintsLoaderImpl.class);
    private final PasswordScoreService passwordScoreService;
    private final DarkFeatureManager darkFeatureManager;

    public PasswordConstraintsLoaderImpl(PasswordScoreService passwordScoreService, DarkFeatureManager darkFeatureManager) {
        this.passwordScoreService = passwordScoreService;
        this.darkFeatureManager = darkFeatureManager;
    }

    @Override
    public Set<PasswordConstraint> getFromDirectoryAttributes(long directoryId, Attributes attributes) {
        ImmutableSet.Builder setBuilder = ImmutableSet.builder();
        String regex = attributes.getValue("password_regex");
        if (regex != null) {
            setBuilder.add((Object)new RegexConstraint(regex));
        }
        PasswordScore minimumPasswordScore = this.getMinimumPasswordScore(directoryId, attributes);
        if (this.isPasswordPolicyEnabled() && minimumPasswordScore != null) {
            setBuilder.add((Object)new PasswordScoreConstraint(minimumPasswordScore, this.passwordScoreService));
        }
        String minLength = attributes.getValue("password_minimum_length");
        if (this.isPasswordPolicyEnabled() && minLength != null) {
            setBuilder.add((Object)new PasswordLengthConstraint(Integer.parseInt(minLength)));
        }
        return setBuilder.build();
    }

    @Nullable
    private PasswordScore getMinimumPasswordScore(long directoryId, Attributes attributes) {
        String scoreRanking = attributes.getValue("password_minimum_score");
        if (scoreRanking == null) {
            return null;
        }
        try {
            return PasswordScore.fromRanking((long)Long.parseLong(scoreRanking));
        }
        catch (IllegalArgumentException e) {
            logger.error("An invalid ranking for password score of {} was found in the database for directory {}", (Object)scoreRanking, (Object)directoryId);
            return null;
        }
    }

    protected boolean isPasswordPolicyEnabled() {
        return this.darkFeatureManager.isFeatureEnabledForAllUsers(PASSWORD_POLICY_FEATURE);
    }
}

