/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.dao.token;

import com.atlassian.crowd.dao.token.TokenDAO;
import com.atlassian.crowd.dao.token.TokenDAOSearchUtils;
import com.atlassian.crowd.exception.ObjectAlreadyExistsException;
import com.atlassian.crowd.exception.ObjectNotFoundException;
import com.atlassian.crowd.manager.cache.CacheManager;
import com.atlassian.crowd.manager.cache.NotInCacheException;
import com.atlassian.crowd.model.token.Token;
import com.atlassian.crowd.model.token.TokenLifetime;
import com.atlassian.crowd.search.Entity;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.util.SearchResultsUtil;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenDAOMemory
implements TokenDAO {
    public static final String RANDOM_HASH_CACHE = Token.class.getName() + ".random-hash-cache";
    public static final String IDENTIFIER_HASH_CACHE;
    @Deprecated
    public static final String IDENTIFIER_HASH_CAHE;
    private static final Logger logger;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final CacheManager cacheManager;

    public TokenDAOMemory(CacheManager cacheManager) {
        this.cacheManager = (CacheManager)Preconditions.checkNotNull((Object)cacheManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Token findByRandomHash(String randomHash) throws ObjectNotFoundException {
        this.lock.readLock().lock();
        try {
            Token token = this.internalFindByRandomHash(randomHash);
            return token;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private Token internalFindByRandomHash(String randomHash) throws ObjectNotFoundException {
        try {
            return (Token)this.cacheManager.get(RANDOM_HASH_CACHE, (Serializable)((Object)randomHash));
        }
        catch (NotInCacheException e) {
            throw new ObjectNotFoundException(Token.class, (Object)randomHash);
        }
    }

    @Override
    public Token findByIdentifierHash(String identifierHash) throws ObjectNotFoundException {
        this.lock.readLock().lock();
        try {
            Token token = (Token)this.cacheManager.get(IDENTIFIER_HASH_CACHE, (Serializable)((Object)identifierHash));
            return token;
        }
        catch (NotInCacheException e) {
            throw new ObjectNotFoundException(Token.class, (Object)identifierHash);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Token add(Token token) throws ObjectAlreadyExistsException {
        this.lock.writeLock().lock();
        try {
            if (this.containsByIdentifierHash(token.getIdentifierHash())) {
                throw new ObjectAlreadyExistsException(token.getIdentifierHash());
            }
            this.cacheManager.put(RANDOM_HASH_CACHE, (Serializable)((Object)token.getRandomHash()), (Serializable)token);
            this.cacheManager.put(IDENTIFIER_HASH_CACHE, (Serializable)((Object)token.getIdentifierHash()), (Serializable)token);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return token;
    }

    private boolean containsByIdentifierHash(String identifierHash) {
        try {
            this.cacheManager.get(IDENTIFIER_HASH_CACHE, (Serializable)((Object)identifierHash));
            return true;
        }
        catch (NotInCacheException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Token update(Token token) {
        this.lock.writeLock().lock();
        try {
            token.setLastAccessedTime(System.currentTimeMillis());
            this.cacheManager.put(RANDOM_HASH_CACHE, (Serializable)((Object)token.getRandomHash()), (Serializable)token);
            this.cacheManager.put(IDENTIFIER_HASH_CACHE, (Serializable)((Object)token.getIdentifierHash()), (Serializable)token);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Token token) {
        this.lock.writeLock().lock();
        try {
            this.cacheManager.remove(RANDOM_HASH_CACHE, (Serializable)((Object)token.getRandomHash()));
            this.cacheManager.remove(IDENTIFIER_HASH_CACHE, (Serializable)((Object)token.getIdentifierHash()));
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Token> search(EntityQuery<? extends Token> query) {
        Preconditions.checkArgument((query.getEntityDescriptor().getEntityType() == Entity.TOKEN ? 1 : 0) != 0, (Object)"TokenDAO can only evaluate EntityQueries for Entity.TOKEN");
        ImmutableList.Builder tokens = ImmutableList.builder();
        this.lock.readLock().lock();
        try {
            for (String key : this.findRandomHashKeys()) {
                try {
                    Token token = this.internalFindByRandomHash(key);
                    if (!TokenDAOSearchUtils.tokenMatchesSearchRestriction(token, query.getSearchRestriction())) continue;
                    tokens.add((Object)token);
                }
                catch (ObjectNotFoundException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return SearchResultsUtil.constrainResults((List)tokens.build(), (int)query.getStartIndex(), (int)query.getMaxResults());
    }

    private List<String> findRandomHashKeys() {
        return this.cacheManager.getAllKeys(RANDOM_HASH_CACHE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(long directoryId, String name) {
        this.lock.writeLock().lock();
        try {
            List<String> keys = this.findRandomHashKeys();
            this.remove(keys, directoryId, name);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void remove(Iterable<String> keys, long directoryId, String name) {
        for (String key : keys) {
            try {
                Token token = this.internalFindByRandomHash(key);
                if (token.getDirectoryId() != directoryId || !token.getName().equals(name)) continue;
                this.remove(token);
            }
            catch (ObjectNotFoundException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeExcept(long directoryId, String name, String exclusionToken) {
        this.lock.writeLock().lock();
        try {
            Iterable keys = Iterables.filter(this.findRandomHashKeys(), (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)exclusionToken)));
            this.remove(keys, directoryId, name);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void removeAll(long directoryId) {
        this.lock.writeLock().lock();
        try {
            for (String key : this.findRandomHashKeys()) {
                try {
                    Token token = this.internalFindByRandomHash(key);
                    if (token.getDirectoryId() != directoryId) continue;
                    this.remove(token);
                }
                catch (ObjectNotFoundException e) {
                    throw new IllegalStateException("Key already removed: " + key);
                    return;
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void removeExpiredTokens(Date currentTime, long maxLifeInSeconds) {
        this.lock.writeLock().lock();
        try {
            for (String key : this.findRandomHashKeys()) {
                try {
                    Token token = this.internalFindByRandomHash(key);
                    long effectiveTokenSessionTime = TokenDAOMemory.getEffectiveTokenSessionTime(token, maxLifeInSeconds);
                    Date expiryTime = new Date(token.getLastAccessedTime() + TimeUnit.SECONDS.toMillis(effectiveTokenSessionTime));
                    if (!expiryTime.before(currentTime)) continue;
                    this.remove(token);
                }
                catch (ObjectNotFoundException e) {
                    throw new IllegalStateException("Key already removed: " + key);
                    return;
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private static long getEffectiveTokenSessionTime(Token token, long defaultMaxLifeInSeconds) {
        TokenLifetime tokenLifetime = token.getLifetime();
        if (tokenLifetime.isDefault()) {
            return defaultMaxLifeInSeconds;
        }
        return Math.min(tokenLifetime.getSeconds(), defaultMaxLifeInSeconds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Token> loadAll() {
        this.lock.readLock().lock();
        try {
            ImmutableList.Builder tokens = ImmutableList.builder();
            for (String key : this.findRandomHashKeys()) {
                try {
                    Token token = this.internalFindByRandomHash(key);
                    tokens.add((Object)token);
                }
                catch (ObjectNotFoundException e) {
                    throw new IllegalStateException("Key already removed: " + key);
                }
            }
            ImmutableList immutableList = tokens.build();
            return immutableList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveAll(Collection<Token> tokens) {
        Preconditions.checkNotNull(tokens);
        this.lock.writeLock().lock();
        try {
            for (Token token : tokens) {
                this.cacheManager.put(RANDOM_HASH_CACHE, (Serializable)((Object)token.getRandomHash()), (Serializable)token);
                this.cacheManager.put(IDENTIFIER_HASH_CACHE, (Serializable)((Object)token.getIdentifierHash()), (Serializable)token);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAll() {
        this.lock.writeLock().lock();
        try {
            this.cacheManager.removeAll(RANDOM_HASH_CACHE);
            this.cacheManager.removeAll(IDENTIFIER_HASH_CACHE);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    static {
        IDENTIFIER_HASH_CAHE = IDENTIFIER_HASH_CACHE = Token.class.getName() + ".identifier-hash-cache";
        logger = LoggerFactory.getLogger(TokenDAOMemory.class);
    }
}

