/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.model.token;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.commons.lang3.Validate;

public class ResetPasswordToken
implements Serializable {
    private static final long serialVersionUID = -1897661365186057736L;
    private final long expiryDate;
    private final String token;
    private final String username;
    private final long directoryId;

    public ResetPasswordToken(long expiryDate, String token, String username, long directoryId) {
        Validate.notNull((Object)"token cannot be null", (String)token, (Object[])new Object[0]);
        Validate.notNull((Object)"username cannot be null", (String)username, (Object[])new Object[0]);
        this.expiryDate = expiryDate;
        this.token = token;
        this.username = username;
        this.directoryId = directoryId;
    }

    public long getExpiryDate() {
        return this.expiryDate;
    }

    public String getToken() {
        return this.token;
    }

    public String getUsername() {
        return this.username;
    }

    public long getDirectoryId() {
        return this.directoryId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResetPasswordToken)) {
            return false;
        }
        ResetPasswordToken token = (ResetPasswordToken)o;
        if (this.getExpiryDate() != token.getExpiryDate()) {
            return false;
        }
        if (this.getToken() != null ? !this.getToken().equals(token.getToken()) : token.getToken() != null) {
            return false;
        }
        if (this.getUsername() != null ? !this.getUsername().equals(token.getUsername()) : token.getUsername() != null) {
            return false;
        }
        return this.getDirectoryId() == token.getDirectoryId();
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + (int)(this.expiryDate ^ this.expiryDate >>> 32);
        result = 31 * result + (this.token != null ? this.token.hashCode() : 0);
        result = 31 * result + (this.username != null ? this.username.hashCode() : 0);
        result = 31 * result + (int)(this.directoryId ^ this.directoryId >>> 32);
        return result;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }
}

