/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.model.group;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.model.InternalDirectoryEntity;
import com.atlassian.crowd.model.InternalEntityTemplate;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupComparator;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.group.InternalDirectoryGroup;
import com.atlassian.crowd.util.InternalEntityUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

public class InternalGroup
extends InternalDirectoryEntity
implements InternalDirectoryGroup {
    private String lowerName;
    private GroupType type;
    private String description;
    private boolean isLocal;

    protected InternalGroup() {
    }

    public InternalGroup(InternalEntityTemplate internalEntityTemplate, Directory directory, GroupTemplate groupTemplate) {
        super(internalEntityTemplate, directory);
        this.type = groupTemplate.getType();
        this.updateDetailsFrom((Group)groupTemplate);
    }

    public InternalGroup(Group group, Directory directory) {
        Validate.notNull((Object)directory, (String)"directory argument cannot be null");
        this.setName(group.getName());
        this.directory = directory;
        this.type = group.getType();
        this.updateDetailsFrom(group);
    }

    private void validateGroup(Group group) {
        Validate.notNull((Object)group, (String)"group argument cannot be null");
        Validate.notNull((Object)group.getDirectoryId(), (String)"group argument cannot have a null directoryID");
        Validate.notNull((Object)group.getName(), (String)"group argument cannot have a null name");
        Validate.notNull((Object)group.getType(), (String)"type argument cannot be null");
        Validate.isTrue((group.getDirectoryId() == this.getDirectoryId() ? 1 : 0) != 0, (String)"directoryID of updated group does not match the directoryID of the existing group.");
        Validate.isTrue((boolean)group.getName().equals(this.getName()), (String)"group name of updated group does not match the group name of the existing group.");
    }

    public void updateDetailsFrom(Group group) {
        this.validateGroup(group);
        this.active = group.isActive();
        this.description = InternalEntityUtils.truncateValue((String)group.getDescription());
    }

    public void renameTo(String newName) {
        Validate.isTrue((boolean)StringUtils.isNotBlank((String)newName), (String)"the new name cannot be null or blank");
        this.setName(newName);
    }

    protected void setName(String name) {
        InternalEntityUtils.validateLength((String)name);
        this.name = name;
        this.lowerName = IdentifierUtils.toLowerCase((String)name);
    }

    public String getDescription() {
        return this.description;
    }

    public GroupType getType() {
        return this.type;
    }

    public String getLowerName() {
        return this.lowerName;
    }

    private void setLowerName(String lowerName) {
        this.lowerName = lowerName;
    }

    private void setDescription(String description) {
        this.description = description;
    }

    private void setType(GroupType type) {
        this.type = type;
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public void setLocal(boolean local) {
        this.isLocal = local;
    }

    public boolean equals(Object o) {
        return GroupComparator.equalsObject((Group)this, (Object)o);
    }

    public int hashCode() {
        return GroupComparator.hashCode((Group)this);
    }

    public int compareTo(Group o) {
        return GroupComparator.compareTo((Group)this, (Group)o);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.getId()).append("name", (Object)this.getName()).append("type", (Object)this.getType()).append("active", this.isActive()).append("description", (Object)this.getDescription()).append("lowerName", (Object)this.getLowerName()).append("createdDate", (Object)this.getCreatedDate()).append("updatedDate", (Object)this.getUpdatedDate()).append("directoryId", this.getDirectoryId()).toString();
    }
}

