/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.search.hibernate;

import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.model.alias.Alias;
import com.atlassian.crowd.model.application.ApplicationImpl;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.group.InternalGroup;
import com.atlassian.crowd.model.membership.InternalMembership;
import com.atlassian.crowd.model.membership.MembershipType;
import com.atlassian.crowd.model.token.Token;
import com.atlassian.crowd.model.user.InternalUser;
import com.atlassian.crowd.search.Entity;
import com.atlassian.crowd.search.hibernate.HQLQuery;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.BooleanRestriction;
import com.atlassian.crowd.search.query.entity.restriction.MatchMode;
import com.atlassian.crowd.search.query.entity.restriction.NullRestriction;
import com.atlassian.crowd.search.query.entity.restriction.PropertyRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.AliasTermKeys;
import com.atlassian.crowd.search.query.entity.restriction.constants.DirectoryTermKeys;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.crowd.search.query.entity.restriction.constants.TokenTermKeys;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import java.util.Date;

public class HQLQueryTranslater {
    protected static final String HQL_USER_NAME = "lowerName";
    protected static final String HQL_USER_EMAIL_ADDRESS = "lowerEmailAddress";
    protected static final String HQL_USER_FIRST_NAME = "lowerFirstName";
    protected static final String HQL_USER_LAST_NAME = "lowerLastName";
    protected static final String HQL_USER_DISPLAY_NAME = "lowerDisplayName";
    protected static final String HQL_USER_ACTIVE = "active";
    protected static final String HQL_CREATED_DATE = "createdDate";
    protected static final String HQL_UPDATED_DATE = "updatedDate";
    protected static final String HQL_GROUP_NAME = "lowerName";
    protected static final String HQL_GROUP_ACTIVE = "active";
    protected static final String HQL_GROUP_TYPE = "type";
    protected static final String HQL_GROUP_LOCAL = "local";
    protected static final String HQL_TOKEN_NAME = "name";
    protected static final String HQL_TOKEN_LAST_ACCESSED_DATE = "lastAccessedDate";
    protected static final String HQL_TOKEN_DIRECTORY_ID = "directoryId";
    protected static final String HQL_TOKEN_RANDOM_NUMBER = "randomNumber";
    protected static final String HQL_DIRECTORY_NAME = "lowerName";
    protected static final String HQL_DIRECTORY_ACTIVE = "active";
    protected static final String HQL_DIRECTORY_TYPE = "type";
    protected static final String HQL_DIRECTORY_IMPLEMENTATION_CLASS = "lowerImplementationClass";
    protected static final String HQL_APPLICATION_NAME = "lowerName";
    protected static final String HQL_APPLICATION_ACTIVE = "active";
    protected static final String HQL_APPLICATION_TYPE = "type";
    protected static final String HQL_ALIAS_NAME = "lowerAlias";
    protected static final String HQL_ALIAS_APPLICATION_ID = "application.id";
    protected static final String HQL_ALIAS_USERNAME = "lowerName";
    protected static final String HQL_ATTRIBUTE_NAME = "name";
    protected static final String HQL_ATTRIBUTE_VALUE = "lowerValue";
    protected static final String HQL_ATTRIBUTE_ALIAS = "attr";
    protected static final String HQL_DIRECTORY_ID = ".directory.id";
    protected static final String HQL_MEMBERSHIP_ALIAS = "mem";
    protected static final String HQL_MEMBERSHIP_TYPE = "membershipType";
    protected static final String HQL_MEMBERSHIP_GROUP_TYPE = "groupType";

    public HQLQuery asHQL(long directoryID, MembershipQuery query) {
        if (query.getReturnType() == String.class) {
            return this.membershipNamesQueryAsHQL(directoryID, query);
        }
        return this.membershipEntityQueryAsHQL(directoryID, query);
    }

    protected HQLQuery membershipNamesQueryAsHQL(long directoryID, MembershipQuery query) {
        HQLQuery hql = new HQLQuery();
        hql.appendSelect(HQL_MEMBERSHIP_ALIAS);
        hql.appendOrderBy(HQL_MEMBERSHIP_ALIAS);
        if (query.isFindChildren()) {
            hql.appendSelect(".childName, ").append(HQL_MEMBERSHIP_ALIAS).append(".lowerChildName");
            hql.appendOrderBy(".lowerChildName");
        } else {
            hql.appendSelect(".parentName, ").append(HQL_MEMBERSHIP_ALIAS).append(".lowerParentName");
            hql.appendOrderBy(".lowerParentName");
        }
        hql.appendFrom(InternalMembership.class.getSimpleName()).append(" ").append(HQL_MEMBERSHIP_ALIAS);
        if (query.isFindChildren()) {
            hql.appendWhere(HQL_MEMBERSHIP_ALIAS).append(".lowerParentName = ?");
        } else {
            hql.appendWhere(HQL_MEMBERSHIP_ALIAS).append(".lowerChildName = ?");
        }
        hql.addParameterValue(IdentifierUtils.toLowerCase((String)query.getEntityNameToMatch()));
        this.appendMembershipTypeAndDirectoryIDAndGroupType(directoryID, query, hql);
        return hql;
    }

    private void appendMembershipTypeAndDirectoryIDAndGroupType(long directoryID, MembershipQuery query, HQLQuery hql) {
        hql.appendWhere(" AND ").append(HQL_MEMBERSHIP_ALIAS).append(".").append(HQL_MEMBERSHIP_TYPE).append(" = ?");
        if (query.getEntityToMatch().getEntityType() == Entity.GROUP && query.getEntityToReturn().getEntityType() == Entity.GROUP) {
            hql.addParameterValue(MembershipType.GROUP_GROUP);
        } else {
            hql.addParameterValue(MembershipType.GROUP_USER);
        }
        hql.appendWhere(" AND ").append(HQL_MEMBERSHIP_ALIAS).append(".directory.id = ?");
        hql.addParameterValue(directoryID);
        GroupType groupType = null;
        if (query.getEntityToMatch().getEntityType() == Entity.GROUP) {
            groupType = query.getEntityToMatch().getGroupType();
        }
        if (query.getEntityToReturn().getEntityType() == Entity.GROUP) {
            if (groupType != null && groupType != query.getEntityToReturn().getGroupType()) {
                throw new IllegalArgumentException("Cannot search memberships of conflicting group types");
            }
            groupType = query.getEntityToReturn().getGroupType();
        }
        if (groupType != null) {
            hql.appendWhere(" AND ").append(HQL_MEMBERSHIP_ALIAS).append(".").append(HQL_MEMBERSHIP_GROUP_TYPE).append(" = ?");
            hql.addParameterValue(groupType);
        }
    }

    protected HQLQuery membershipEntityQueryAsHQL(long directoryID, MembershipQuery query) {
        HQLQuery hql = new HQLQuery();
        String persistedClass = this.transformEntityToPersistedClass(query.getEntityToReturn().getEntityType());
        String alias = this.transformEntityToAlias(query.getEntityToReturn().getEntityType());
        hql.appendSelect(alias);
        hql.appendFrom(persistedClass).append(" ").append(alias).append(", ").append(InternalMembership.class.getSimpleName()).append(" ").append(HQL_MEMBERSHIP_ALIAS);
        hql.appendWhere(alias).append(".id = ").append(HQL_MEMBERSHIP_ALIAS);
        if (query.isFindChildren()) {
            hql.appendWhere(".childId AND ").append(HQL_MEMBERSHIP_ALIAS).append(".lowerParentName = ?");
        } else {
            hql.appendWhere(".parentId AND ").append(HQL_MEMBERSHIP_ALIAS).append(".lowerChildName = ?");
        }
        hql.addParameterValue(IdentifierUtils.toLowerCase((String)query.getEntityNameToMatch()));
        this.appendMembershipTypeAndDirectoryIDAndGroupType(directoryID, query, hql);
        return hql;
    }

    public HQLQuery asHQL(EntityQuery entityQuery) {
        HQLQuery hql = new HQLQuery();
        this.appendQueryAsHQL(entityQuery, hql);
        return hql;
    }

    public HQLQuery asHQL(long directoryID, EntityQuery entityQuery) {
        HQLQuery hql = new HQLQuery();
        String entityAlias = this.transformEntityToAlias(entityQuery.getEntityDescriptor().getEntityType());
        hql.appendWhere(entityAlias).append(HQL_DIRECTORY_ID).append(" = ?");
        hql.addParameterValue(directoryID);
        this.appendQueryAsHQL(entityQuery, hql);
        return hql;
    }

    protected void appendQueryAsHQL(EntityQuery query, HQLQuery hql) {
        String persistedClass = this.transformEntityToPersistedClass(query.getEntityDescriptor().getEntityType());
        String alias = this.transformEntityToAlias(query.getEntityDescriptor().getEntityType());
        hql.appendSelect(alias);
        if (query.getReturnType() == String.class) {
            this.appendSelectProjectionAsNames(hql, query.getEntityDescriptor().getEntityType());
        }
        hql.appendFrom(persistedClass).append(" ").append(alias);
        if (query.getEntityDescriptor().getEntityType() == Entity.GROUP && query.getEntityDescriptor().getGroupType() != null) {
            if (hql.whereRequired) {
                hql.appendWhere(" AND ");
            }
            this.appendGroupTypeRestrictionAsHQL(hql, query.getEntityDescriptor().getGroupType());
        }
        if (!(query.getSearchRestriction() instanceof NullRestriction)) {
            if (hql.whereRequired) {
                hql.appendWhere(" AND ");
            }
            this.appendPropertyRestrictionAsHQL(hql, query.getEntityDescriptor().getEntityType(), query.getSearchRestriction());
        }
        this.appendOrderByClause(hql, query.getEntityDescriptor().getEntityType());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void appendPropertyRestrictionAsHQL(HQLQuery hql, Entity entityType, SearchRestriction restriction) {
        if (restriction instanceof NullRestriction) return;
        if (restriction instanceof PropertyRestriction) {
            PropertyRestriction propertyRestriction = (PropertyRestriction)restriction;
            if (MatchMode.NULL == propertyRestriction.getMatchMode()) {
                this.appendIsNullTermRestrictionAsHSQL(hql, entityType, propertyRestriction);
                return;
            } else if (String.class.equals((Object)propertyRestriction.getProperty().getPropertyType())) {
                this.appendStringTermRestrictionAsHQL(hql, entityType, (PropertyRestriction<String>)propertyRestriction);
                return;
            } else if (Boolean.class.equals((Object)propertyRestriction.getProperty().getPropertyType())) {
                this.appendBooleanTermRestrictionAsHQL(hql, entityType, (PropertyRestriction<Boolean>)propertyRestriction);
                return;
            } else if (Enum.class.equals((Object)propertyRestriction.getProperty().getPropertyType())) {
                this.appendEnumTermRestrictionAsHQL(hql, entityType, (PropertyRestriction<Enum>)propertyRestriction);
                return;
            } else if (Date.class.isAssignableFrom(propertyRestriction.getProperty().getPropertyType())) {
                this.appendDateTermRestriction(hql, entityType, (PropertyRestriction<? extends Date>)propertyRestriction);
                return;
            } else {
                if (!Number.class.isAssignableFrom(propertyRestriction.getProperty().getPropertyType())) throw new IllegalArgumentException("ProperyRestriction unsupported: " + restriction.getClass());
                this.appendNumberTermRestriction(hql, entityType, (PropertyRestriction<? extends Number>)propertyRestriction);
            }
            return;
        } else {
            if (!(restriction instanceof BooleanRestriction)) throw new IllegalArgumentException("ProperyRestriction unsupported: " + restriction.getClass());
            this.appendMultiTermRestrictionAsHQL(hql, entityType, (BooleanRestriction)restriction);
        }
    }

    protected void appendIsNullTermRestrictionAsHSQL(HQLQuery hql, Entity entityType, PropertyRestriction<?> restriction) {
        this.appendEntityPropertyAsHQL(hql, entityType, restriction);
        hql.appendWhere("IS NULL");
    }

    private void appendNumberTermRestriction(HQLQuery hql, Entity entityType, PropertyRestriction<? extends Number> restriction) {
        this.appendEntityPropertyAsHQL(hql, entityType, restriction);
        this.appendComparableValueAsHQL(hql, restriction);
    }

    protected void appendDateTermRestriction(HQLQuery hql, Entity entityType, PropertyRestriction<? extends Date> restriction) {
        this.appendEntityPropertyAsHQL(hql, entityType, restriction);
        this.appendComparableValueAsHQL(hql, restriction);
    }

    protected void appendBooleanTermRestrictionAsHQL(HQLQuery hql, Entity entityType, PropertyRestriction<Boolean> restriction) {
        this.appendEntityPropertyAsHQL(hql, entityType, restriction);
        hql.appendWhere("= ?");
        hql.addParameterValue(restriction.getValue());
    }

    protected void appendEnumTermRestrictionAsHQL(HQLQuery hql, Entity entityType, PropertyRestriction<Enum> restriction) {
        this.appendEntityPropertyAsHQL(hql, entityType, restriction);
        hql.appendWhere("= ?");
        hql.addParameterValue(restriction.getValue());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void appendMultiTermRestrictionAsHQL(HQLQuery hql, Entity entityType, BooleanRestriction booleanRestriction) {
        hql.appendWhere(" (");
        boolean first = true;
        for (SearchRestriction restriction : booleanRestriction.getRestrictions()) {
            if (!first) {
                if (booleanRestriction.getBooleanLogic() == BooleanRestriction.BooleanLogic.AND) {
                    hql.appendWhere(" AND ");
                } else {
                    if (booleanRestriction.getBooleanLogic() != BooleanRestriction.BooleanLogic.OR) throw new IllegalArgumentException("BooleanLogic unsupported: " + booleanRestriction.getBooleanLogic());
                    hql.appendWhere(" OR ");
                }
            } else {
                first = false;
            }
            this.appendPropertyRestrictionAsHQL(hql, entityType, restriction);
        }
        hql.appendWhere(") ");
    }

    protected void appendStringTermRestrictionAsHQL(HQLQuery hql, Entity entityType, PropertyRestriction<String> restriction) {
        this.appendEntityPropertyAsHQL(hql, entityType, restriction);
        this.appendStringValueAsHQL(hql, restriction);
    }

    protected void appendEntityPropertyAsHQL(HQLQuery hql, Entity entityType, PropertyRestriction restriction) {
        switch (entityType) {
            case USER: {
                this.appendUserPropertyAsHQL(hql, restriction);
                break;
            }
            case GROUP: {
                this.appendGroupPropertyAsHQL(hql, restriction);
                break;
            }
            case TOKEN: {
                this.appendTokenPropertyAsHQL(hql, restriction);
                break;
            }
            case DIRECTORY: {
                this.appendDirectoryPropertyAsHQL(hql, restriction);
                break;
            }
            case APPLICATION: {
                this.appendApplicationPropertyAsHQL(hql, restriction);
                break;
            }
            case ALIAS: {
                this.appendAliasPropertyAsHQL(hql, restriction);
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot form property restriction for entity of type <" + entityType + ">");
            }
        }
    }

    private void appendAliasPropertyAsHQL(HQLQuery hql, PropertyRestriction restriction) {
        String alias = this.transformEntityToAlias(Entity.ALIAS);
        if (restriction.getProperty().equals(AliasTermKeys.ALIAS)) {
            hql.appendWhere(alias).append(".").append(HQL_ALIAS_NAME);
        } else if (restriction.getProperty().equals(AliasTermKeys.APPLICATION_ID)) {
            hql.appendWhere(alias).append(".").append(HQL_ALIAS_APPLICATION_ID);
        } else {
            throw new IllegalArgumentException("Alias does not support searching by property: " + restriction.getProperty().getPropertyName());
        }
        hql.appendWhere(" ");
    }

    private void appendApplicationPropertyAsHQL(HQLQuery hql, PropertyRestriction restriction) {
        String alias = this.transformEntityToAlias(Entity.APPLICATION);
        if (restriction.getProperty().equals(DirectoryTermKeys.NAME)) {
            hql.appendWhere(alias).append(".").append("lowerName");
        } else if (restriction.getProperty().equals(DirectoryTermKeys.ACTIVE)) {
            hql.appendWhere(alias).append(".").append("active");
        } else if (restriction.getProperty().equals(DirectoryTermKeys.TYPE)) {
            hql.appendWhere(alias).append(".").append("type");
        } else {
            throw new IllegalArgumentException("Application does not support searching by property: " + restriction.getProperty().getPropertyName());
        }
        hql.appendWhere(" ");
    }

    protected void appendDirectoryPropertyAsHQL(HQLQuery hql, PropertyRestriction restriction) {
        String alias = this.transformEntityToAlias(Entity.DIRECTORY);
        if (restriction.getProperty().equals(DirectoryTermKeys.NAME)) {
            hql.appendWhere(alias).append(".").append("lowerName");
        } else if (restriction.getProperty().equals(DirectoryTermKeys.ACTIVE)) {
            hql.appendWhere(alias).append(".").append("active");
        } else if (restriction.getProperty().equals(DirectoryTermKeys.IMPLEMENTATION_CLASS)) {
            hql.appendWhere(alias).append(".").append(HQL_DIRECTORY_IMPLEMENTATION_CLASS);
        } else if (restriction.getProperty().equals(DirectoryTermKeys.TYPE)) {
            hql.appendWhere(alias).append(".").append("type");
        } else {
            throw new IllegalArgumentException("Directory does not support searching by property: " + restriction.getProperty().getPropertyName());
        }
        hql.appendWhere(" ");
    }

    protected void appendTokenPropertyAsHQL(HQLQuery hql, PropertyRestriction restriction) {
        String tokenAlias = this.transformEntityToAlias(Entity.TOKEN);
        if (restriction.getProperty().equals(TokenTermKeys.NAME)) {
            hql.appendWhere(tokenAlias).append(".").append("name");
        } else if (restriction.getProperty().equals(TokenTermKeys.LAST_ACCESSED_DATE)) {
            hql.appendWhere(tokenAlias).append(".").append(HQL_TOKEN_LAST_ACCESSED_DATE);
        } else if (restriction.getProperty().equals(TokenTermKeys.DIRECTORY_ID)) {
            hql.appendWhere(tokenAlias).append(".").append(HQL_TOKEN_DIRECTORY_ID);
        } else if (restriction.getProperty().equals(TokenTermKeys.RANDOM_NUMBER)) {
            hql.appendWhere(tokenAlias).append(".").append(HQL_TOKEN_RANDOM_NUMBER);
        } else {
            throw new IllegalArgumentException("Token does not support searching by property: " + restriction.getProperty().getPropertyName());
        }
        hql.appendWhere(" ");
    }

    protected void appendGroupTypeRestrictionAsHQL(HQLQuery hql, GroupType groupType) {
        if (groupType != null) {
            String groupAlias = this.transformEntityToAlias(Entity.GROUP);
            hql.appendWhere(groupAlias).append(".").append("type");
            hql.appendWhere(" = ?");
            hql.addParameterValue(groupType);
        }
    }

    protected void appendGroupPropertyAsHQL(HQLQuery hql, PropertyRestriction restriction) {
        String groupAlias = this.transformEntityToAlias(Entity.GROUP);
        if (restriction.getProperty().equals(GroupTermKeys.NAME)) {
            hql.appendWhere(groupAlias).append(".").append("lowerName");
        } else if (restriction.getProperty().equals(GroupTermKeys.ACTIVE)) {
            hql.appendWhere(groupAlias).append(".").append("active");
        } else if (restriction.getProperty().equals(GroupTermKeys.CREATED_DATE)) {
            hql.appendWhere(groupAlias).append(".").append(HQL_CREATED_DATE);
        } else if (restriction.getProperty().equals(GroupTermKeys.UPDATED_DATE)) {
            hql.appendWhere(groupAlias).append(".").append(HQL_UPDATED_DATE);
        } else if (restriction.getProperty().equals(GroupTermKeys.LOCAL)) {
            hql.appendWhere(groupAlias).append(".").append(HQL_GROUP_LOCAL);
        } else {
            StringBuilder alias = hql.getNextAlias(HQL_ATTRIBUTE_ALIAS);
            if (restriction.getMatchMode() == MatchMode.NULL) {
                hql.appendWhere("? NOT IN (SELECT ").append((CharSequence)alias).append(".").append("name").append(" FROM InternalGroupAttribute ").append((CharSequence)alias).append(" WHERE ").append(groupAlias).append(".id = ").append((CharSequence)alias).append(".group.id").append(")");
                hql.addParameterValue(restriction.getProperty().getPropertyName());
                hql.appendWhere(" AND ?");
                hql.addParameterValue(null);
            } else {
                hql.appendFrom(", InternalGroupAttribute ").append((CharSequence)alias);
                hql.appendWhere(groupAlias).append(".id = ").append((CharSequence)alias).append(".group.id").append(" AND ").append((CharSequence)alias).append(".").append("name").append(" = ?").append(" AND ").append((CharSequence)alias).append(".").append(HQL_ATTRIBUTE_VALUE);
                hql.addParameterValue(restriction.getProperty().getPropertyName());
            }
            hql.requireDistinct();
        }
        hql.appendWhere(" ");
    }

    protected void appendUserPropertyAsHQL(HQLQuery hql, PropertyRestriction restriction) {
        String userAlias = this.transformEntityToAlias(Entity.USER);
        if (restriction.getProperty().equals(UserTermKeys.USERNAME)) {
            hql.appendWhere(userAlias).append(".").append("lowerName");
        } else if (restriction.getProperty().equals(UserTermKeys.EMAIL)) {
            hql.appendWhere(userAlias).append(".").append(HQL_USER_EMAIL_ADDRESS);
        } else if (restriction.getProperty().equals(UserTermKeys.FIRST_NAME)) {
            hql.appendWhere(userAlias).append(".").append(HQL_USER_FIRST_NAME);
        } else if (restriction.getProperty().equals(UserTermKeys.LAST_NAME)) {
            hql.appendWhere(userAlias).append(".").append(HQL_USER_LAST_NAME);
        } else if (restriction.getProperty().equals(UserTermKeys.DISPLAY_NAME)) {
            hql.appendWhere(userAlias).append(".").append(HQL_USER_DISPLAY_NAME);
        } else if (restriction.getProperty().equals(UserTermKeys.ACTIVE)) {
            hql.appendWhere(userAlias).append(".").append("active");
        } else if (restriction.getProperty().equals(UserTermKeys.CREATED_DATE)) {
            hql.appendWhere(userAlias).append(".").append(HQL_CREATED_DATE);
        } else if (restriction.getProperty().equals(UserTermKeys.UPDATED_DATE)) {
            hql.appendWhere(userAlias).append(".").append(HQL_UPDATED_DATE);
        } else {
            StringBuilder attrAlias = hql.getNextAlias(HQL_ATTRIBUTE_ALIAS);
            if (restriction.getMatchMode() == MatchMode.NULL) {
                hql.appendWhere("? NOT IN (SELECT ").append((CharSequence)attrAlias).append(".").append("name").append(" FROM InternalUserAttribute ").append((CharSequence)attrAlias).append(" WHERE ").append(userAlias).append(".id = ").append((CharSequence)attrAlias).append(".user.id").append(")");
                hql.addParameterValue(restriction.getProperty().getPropertyName());
                hql.appendWhere(" AND ?");
                hql.addParameterValue(null);
            } else {
                hql.appendFrom(", InternalUserAttribute ").append((CharSequence)attrAlias);
                hql.appendWhere(userAlias).append(".id = ").append((CharSequence)attrAlias).append(".user.id").append(" AND ").append((CharSequence)attrAlias).append(".").append("name").append(" = ?").append(" AND ").append((CharSequence)attrAlias).append(".").append(HQL_ATTRIBUTE_VALUE);
                hql.addParameterValue(restriction.getProperty().getPropertyName());
            }
            hql.requireDistinct();
        }
        hql.appendWhere(" ");
    }

    protected void appendStringValueAsHQL(HQLQuery hql, PropertyRestriction<String> restriction) {
        String lowerValue = IdentifierUtils.toLowerCase((String)((String)restriction.getValue()));
        switch (restriction.getMatchMode()) {
            case STARTS_WITH: {
                hql.appendWhere("LIKE ?");
                hql.addParameterValue(lowerValue + "%");
                break;
            }
            case CONTAINS: {
                hql.appendWhere("LIKE ?");
                hql.addParameterValue("%" + lowerValue + "%");
                break;
            }
            default: {
                hql.appendWhere("= ?");
                hql.addParameterValue(lowerValue);
            }
        }
    }

    protected void appendComparableValueAsHQL(HQLQuery hql, PropertyRestriction restriction) {
        switch (restriction.getMatchMode()) {
            case GREATER_THAN: {
                hql.appendWhere("> ?");
                break;
            }
            case LESS_THAN: {
                hql.appendWhere("< ?");
                break;
            }
            default: {
                hql.appendWhere(" = ?");
            }
        }
        hql.addParameterValue(restriction.getValue());
    }

    private String transformEntityToAlias(Entity entity) {
        switch (entity) {
            case USER: {
                return "usr";
            }
            case GROUP: {
                return "grp";
            }
            case TOKEN: {
                return "token";
            }
            case DIRECTORY: {
                return "directory";
            }
            case APPLICATION: {
                return "application";
            }
            case ALIAS: {
                return "alias";
            }
        }
        throw new IllegalArgumentException("Cannot transform entity of type <" + entity + ">");
    }

    private String transformEntityToPersistedClass(Entity entity) {
        switch (entity) {
            case USER: {
                return InternalUser.class.getSimpleName();
            }
            case GROUP: {
                return InternalGroup.class.getSimpleName();
            }
            case TOKEN: {
                return Token.class.getSimpleName();
            }
            case DIRECTORY: {
                return DirectoryImpl.class.getSimpleName();
            }
            case APPLICATION: {
                return ApplicationImpl.class.getSimpleName();
            }
            case ALIAS: {
                return Alias.class.getSimpleName();
            }
        }
        throw new IllegalArgumentException("Cannot transform entity of type <" + entity + ">");
    }

    private String transormEntityToNameField(Entity entity) {
        switch (entity) {
            case USER: {
                return "lowerName";
            }
            case GROUP: {
                return "lowerName";
            }
            case TOKEN: {
                return "name";
            }
            case DIRECTORY: {
                return "lowerName";
            }
            case APPLICATION: {
                return "lowerName";
            }
            case ALIAS: {
                return "lowerName";
            }
        }
        throw new IllegalArgumentException("Cannot transform entity of type <" + entity + ">");
    }

    private void appendSelectProjectionAsNames(HQLQuery hql, Entity entity) {
        hql.appendSelect(".name");
        if (entity == Entity.USER || entity == Entity.GROUP || entity == Entity.DIRECTORY || entity == Entity.APPLICATION || entity == Entity.ALIAS) {
            hql.appendSelect(", ").append(this.transformEntityToAlias(entity)).append(".lowerName");
        }
    }

    private void appendOrderByClause(HQLQuery hql, Entity entity) {
        hql.appendOrderBy(this.transformEntityToAlias(entity)).append(".").append(this.transormEntityToNameField(entity));
    }
}

