/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.util.persistence.hibernate.batch.hibernate3;

import com.atlassian.crowd.util.persistence.hibernate.batch.AbstractBatchProcessor;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hibernate3BatchProcessor
extends AbstractBatchProcessor {
    private static final Logger logger = LoggerFactory.getLogger(Hibernate3BatchProcessor.class);
    private static ThreadLocal<Session> currentSessionHolder = new ThreadLocal();
    private final SessionFactory sessionFactory;

    public Hibernate3BatchProcessor(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    private Session openSession() {
        if (currentSessionHolder.get() != null) {
            throw new IllegalStateException("session already open");
        }
        Session session = this.sessionFactory.openSession();
        session.setFlushMode(FlushMode.MANUAL);
        session.setCacheMode(CacheMode.IGNORE);
        currentSessionHolder.set(session);
        logger.debug("open new session [ {} ]", (Object)currentSessionHolder.get());
        return session;
    }

    private void flushSession() {
        Session session = Hibernate3BatchProcessor.getSession();
        if (session != null) {
            logger.debug("flush session [ {} ]", (Object)session);
            session.flush();
        }
    }

    private void clearSession() {
        Session session = Hibernate3BatchProcessor.getSession();
        if (session != null) {
            logger.debug("clear session [ {} ]", (Object)session);
            session.clear();
        }
    }

    public static Session getSession() {
        return currentSessionHolder.get();
    }

    private void closeSession() {
        if (currentSessionHolder.get() != null) {
            logger.debug("close session [ {} ]", (Object)currentSessionHolder.get());
            currentSessionHolder.get().close();
            currentSessionHolder.set(null);
        }
    }

    protected void beforeProcessCollection() {
        this.openSession();
    }

    protected void afterProcessCollection() {
        this.closeSession();
    }

    protected void beforeProcessBatch() {
        this.startTransaction();
    }

    protected void afterProcessBatch() {
        this.commitTransaction();
    }

    protected void rollbackProcessBatch() {
        this.rollbackTransaction();
    }

    protected void beforeProcessIndividual() {
        this.startTransaction();
    }

    protected void afterProcessIndividual() {
        this.commitTransaction();
    }

    protected void rollbackProcessIndividual() {
        this.rollbackTransaction();
    }

    private void startTransaction() {
        Transaction transaction = Hibernate3BatchProcessor.getSession().beginTransaction();
        logger.debug("start transaction [ {} ]", (Object)transaction);
    }

    private void commitTransaction() {
        this.flushSession();
        Transaction transaction = Hibernate3BatchProcessor.getSession().getTransaction();
        logger.debug("commit transaction [ {} ]", (Object)transaction);
        transaction.commit();
        this.clearSession();
    }

    private void rollbackTransaction() {
        Transaction transaction = Hibernate3BatchProcessor.getSession().getTransaction();
        transaction.rollback();
        logger.debug("rollback transaction [ {} ]", (Object)transaction);
        this.clearSession();
    }
}

