/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.loader;

import com.atlassian.crowd.directory.AbstractInternalDirectory;
import com.atlassian.crowd.directory.InternalRemoteDirectory;
import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.directory.loader.CachingDirectoryInstanceLoader;
import com.atlassian.crowd.directory.loader.InternalDirectoryInstanceLoader;
import com.atlassian.crowd.directory.loader.RemoteDirectoryInstanceFactoryUtil;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.exception.DirectoryInstantiationException;
import com.atlassian.crowd.util.InstanceFactory;
import com.atlassian.event.api.EventPublisher;
import com.google.common.base.Preconditions;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalDirectoryInstanceLoaderImpl
extends CachingDirectoryInstanceLoader
implements InternalDirectoryInstanceLoader {
    private static final Logger logger = LoggerFactory.getLogger(InternalDirectoryInstanceLoaderImpl.class);
    private final InstanceFactory instanceFactory;

    public InternalDirectoryInstanceLoaderImpl(InstanceFactory instanceFactory, EventPublisher eventPublisher) {
        super(eventPublisher);
        this.instanceFactory = (InstanceFactory)Preconditions.checkNotNull((Object)instanceFactory);
    }

    public InternalRemoteDirectory getRawDirectory(Long id, String className, Map<String, String> directoryAttributes) throws DirectoryInstantiationException {
        return this.getNewDirectory(id, className, directoryAttributes);
    }

    public boolean canLoad(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            return AbstractInternalDirectory.class.isAssignableFrom(clazz);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public InternalRemoteDirectory getDirectory(Directory directory) throws DirectoryInstantiationException {
        return (InternalRemoteDirectory)super.getDirectory(directory);
    }

    @Override
    protected RemoteDirectory getNewDirectory(Directory directory) throws DirectoryInstantiationException {
        Long id = directory.getId();
        String className = directory.getImplementationClass();
        Map directoryAttributes = directory.getAttributes();
        return this.getNewDirectory(id, className, directoryAttributes);
    }

    private InternalRemoteDirectory getNewDirectory(Long id, String className, Map<String, String> directoryAttributes) throws DirectoryInstantiationException {
        return RemoteDirectoryInstanceFactoryUtil.newRemoteDirectory(InternalRemoteDirectory.class, this.instanceFactory, id, className, directoryAttributes);
    }
}

